/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.replay.WorkflowRunTaskHandler;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class WorkflowExecutorCache {
    private final Scope metricsScope;
    private final LoadingCache<String, WorkflowRunTaskHandler> cache;
    private final Lock cacheLock = new ReentrantLock();
    private final Set<String> inProcessing = new HashSet<String>();

    public WorkflowExecutorCache(int workflowCacheSize, Scope scope) {
        Preconditions.checkArgument((workflowCacheSize > 0 ? 1 : 0) != 0, (Object)"Max cache size must be greater than 0");
        this.metricsScope = Objects.requireNonNull(scope);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)workflowCacheSize).removalListener(e -> {
            WorkflowRunTaskHandler entry = (WorkflowRunTaskHandler)e.getValue();
            if (entry != null) {
                entry.close();
            }
        }).build((CacheLoader)new CacheLoader<String, WorkflowRunTaskHandler>(){

            public WorkflowRunTaskHandler load(String key) {
                return null;
            }
        });
    }

    public WorkflowRunTaskHandler getOrCreate(PollWorkflowTaskQueueResponseOrBuilder workflowTask, Scope metricsScope, Callable<WorkflowRunTaskHandler> workflowExecutorFn) throws Exception {
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        if (WorkflowExecutionUtils.isFullHistory(workflowTask)) {
            this.invalidate(execution, metricsScope);
            return workflowExecutorFn.call();
        }
        WorkflowRunTaskHandler workflowRunTaskHandler = this.getForProcessing(execution.getRunId(), metricsScope);
        if (workflowRunTaskHandler != null) {
            return workflowRunTaskHandler;
        }
        return workflowExecutorFn.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowRunTaskHandler getForProcessing(String runId, Scope metricsScope) throws ExecutionException {
        this.cacheLock.lock();
        try {
            WorkflowRunTaskHandler workflowRunTaskHandler = (WorkflowRunTaskHandler)this.cache.get((Object)runId);
            this.inProcessing.add(runId);
            metricsScope.counter("temporal_sticky_cache_hit").inc(1L);
            WorkflowRunTaskHandler workflowRunTaskHandler2 = workflowRunTaskHandler;
            return workflowRunTaskHandler2;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            metricsScope.counter("temporal_sticky_cache_miss").inc(1L);
            WorkflowRunTaskHandler workflowRunTaskHandler = null;
            return workflowRunTaskHandler;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    void markProcessingDone(String runId) {
        this.cacheLock.lock();
        try {
            this.inProcessing.remove(runId);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void addToCache(String runId, WorkflowRunTaskHandler workflowRunTaskHandler) {
        this.cache.put((Object)runId, (Object)workflowRunTaskHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evictAnyNotInProcessing(WorkflowExecution execution, Scope metricsScope) {
        this.cacheLock.lock();
        try {
            this.metricsScope.gauge("temporal_sticky_cache_size").update((double)this.size());
            for (String key : this.cache.asMap().keySet()) {
                if (key.equals(execution.getRunId()) || this.inProcessing.contains(key)) continue;
                this.cache.invalidate((Object)key);
                this.metricsScope.gauge("temporal_sticky_cache_size").update((double)this.size());
                metricsScope.counter("temporal_sticky_cache_thread_forced_eviction").inc(1L);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate(WorkflowExecution execution, Scope metricsScope) {
        this.cacheLock.lock();
        try {
            String runId = execution.getRunId();
            this.cache.invalidate((Object)runId);
            this.inProcessing.remove(runId);
            metricsScope.counter("temporal_sticky_cache_total_forced_eviction").inc(1L);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public long size() {
        return this.cache.size();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

