/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.activity.Activity;
import io.temporal.activity.ActivityExecutionContext;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.client.ActivityCanceledException;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptor;
import io.temporal.common.interceptors.ActivityInterceptor;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.failure.TimeoutFailure;
import io.temporal.internal.common.CheckedExceptionWrapper;
import io.temporal.internal.replay.FailureWrapperException;
import io.temporal.internal.sync.ActivityExecutionContextImpl;
import io.temporal.internal.sync.ActivityInfoImpl;
import io.temporal.internal.sync.CurrentActivityExecutionContext;
import io.temporal.internal.sync.LocalActivityExecutionContextImpl;
import io.temporal.internal.sync.POJOActivityImplMetadata;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.testing.SimulatedTimeoutFailure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class POJOActivityTaskHandler
implements ActivityTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(POJOActivityTaskHandler.class);
    private final DataConverter dataConverter;
    private final ScheduledExecutorService heartbeatExecutor;
    private final Map<String, ActivityTaskExecutor> activities = Collections.synchronizedMap(new HashMap());
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final ActivityInterceptor[] interceptors;

    POJOActivityTaskHandler(WorkflowServiceStubs service, String namespace, DataConverter dataConverter, ScheduledExecutorService heartbeatExecutor, ActivityInterceptor[] interceptors) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.heartbeatExecutor = Objects.requireNonNull(heartbeatExecutor);
        this.interceptors = Objects.requireNonNull(interceptors);
    }

    private void addActivityImplementation(Object activity, BiFunction<Method, Object, ActivityTaskExecutor> newTaskExecutor) {
        if (activity instanceof Class) {
            throw new IllegalArgumentException("Activity object instance expected, not the class");
        }
        Class<?> cls = activity.getClass();
        POJOActivityImplMetadata activityMetadata = POJOActivityImplMetadata.newInstance(cls);
        for (String activityType : activityMetadata.getActivityTypes()) {
            if (this.activities.containsKey(activityType)) {
                throw new IllegalArgumentException("\"" + activityType + "\" activity type is already registered with the worker");
            }
            Method method = activityMetadata.getMethodMetadata(activityType).getMethod();
            ActivityTaskExecutor implementation = newTaskExecutor.apply(method, activity);
            this.activities.put(activityType, implementation);
        }
    }

    private ActivityTaskHandler.Result mapToActivityFailure(Throwable exception, String activityId, Scope metricsScope, boolean isLocalActivity) {
        if (exception instanceof ActivityCanceledException) {
            if (isLocalActivity) {
                metricsScope.counter("temporal_local_activity_canceled").inc(1L);
            } else {
                metricsScope.counter("temporal_activity_canceled").inc(1L);
            }
            String stackTrace = FailureConverter.serializeStackTrace(exception);
            throw new FailureWrapperException(Failure.newBuilder().setStackTrace(stackTrace).setCanceledFailureInfo(CanceledFailureInfo.newBuilder()).build());
        }
        Scope ms = metricsScope.tagged((Map)ImmutableMap.of((Object)"Exception", (Object)exception.getClass().getSimpleName()));
        if (isLocalActivity) {
            ms.counter("temporal_local_activity_failed").inc(1L);
        } else {
            ms.counter("temporal_activity_execution_failed").inc(1L);
        }
        if (exception instanceof TemporalFailure) {
            ((TemporalFailure)exception).setDataConverter(this.dataConverter);
        }
        if (exception instanceof TimeoutFailure) {
            exception = new SimulatedTimeoutFailure((TimeoutFailure)exception);
        }
        Failure failure = FailureConverter.exceptionToFailure(exception);
        RespondActivityTaskFailedRequest.Builder result = RespondActivityTaskFailedRequest.newBuilder().setFailure(failure);
        return new ActivityTaskHandler.Result(activityId, null, new ActivityTaskHandler.Result.TaskFailedResult(result.build(), exception), null, null);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.activities.isEmpty();
    }

    @VisibleForTesting
    public Set<String> getRegisteredActivityTypes() {
        return this.activities.keySet();
    }

    void registerActivityImplementations(Object[] activitiesImplementation) {
        for (Object activity : activitiesImplementation) {
            this.addActivityImplementation(activity, (x$0, x$1) -> new POJOActivityImplementation((Method)x$0, x$1));
        }
    }

    void registerLocalActivityImplementations(Object[] activitiesImplementation) {
        for (Object activity : activitiesImplementation) {
            this.addActivityImplementation(activity, (x$0, x$1) -> new POJOLocalActivityImplementation((Method)x$0, x$1));
        }
    }

    @Override
    public ActivityTaskHandler.Result handle(PollActivityTaskQueueResponse pollResponse, Scope metricsScope, boolean localActivity) {
        String activityType = pollResponse.getActivityType().getName();
        ActivityInfoImpl activityTask = new ActivityInfoImpl(pollResponse, this.namespace, localActivity);
        ActivityTaskExecutor activity = this.activities.get(activityType);
        if (activity == null) {
            String knownTypes = Joiner.on((String)", ").join(this.activities.keySet());
            return this.mapToActivityFailure(new IllegalArgumentException("Activity Type \"" + activityType + "\" is not registered with a worker. Known types are: " + knownTypes), pollResponse.getActivityId(), metricsScope, localActivity);
        }
        return activity.execute(activityTask, metricsScope);
    }

    private class POJOLocalActivityImplementation
    implements ActivityTaskExecutor {
        private final Method method;
        private final Object activity;

        POJOLocalActivityImplementation(Method interfaceMethod, Object activity) {
            this.method = interfaceMethod;
            this.activity = activity;
        }

        @Override
        public ActivityTaskHandler.Result execute(ActivityInfoImpl info, Scope metricsScope) {
            LocalActivityExecutionContextImpl context = new LocalActivityExecutionContextImpl(info, metricsScope);
            Optional<Payloads> input = info.getInput();
            ActivityInboundCallsInterceptor inboundCallsInterceptor = new POJOActivityInboundCallsInterceptor(this.activity, this.method);
            for (ActivityInterceptor interceptor : POJOActivityTaskHandler.this.interceptors) {
                inboundCallsInterceptor = interceptor.interceptActivity(inboundCallsInterceptor);
            }
            inboundCallsInterceptor.init(context);
            try {
                Optional<Payloads> serialized;
                Object[] args = DataConverter.arrayFromPayloads(POJOActivityTaskHandler.this.dataConverter, input, this.method.getParameterTypes(), this.method.getGenericParameterTypes());
                Object result = inboundCallsInterceptor.execute(args);
                RespondActivityTaskCompletedRequest.Builder request = RespondActivityTaskCompletedRequest.newBuilder();
                if (this.method.getReturnType() != Void.TYPE && (serialized = POJOActivityTaskHandler.this.dataConverter.toPayloads(result)).isPresent()) {
                    request.setResult(serialized.get());
                }
                return new ActivityTaskHandler.Result(info.getActivityId(), request.build(), null, null, null);
            }
            catch (Throwable e) {
                e = CheckedExceptionWrapper.unwrap(e);
                if (log.isWarnEnabled()) {
                    log.warn("Local activity failure. ActivityId=" + info.getActivityId() + ", activityType=" + info.getActivityType() + ", attempt=" + info.getAttempt(), e);
                }
                return POJOActivityTaskHandler.this.mapToActivityFailure(e, info.getActivityId(), metricsScope, false);
            }
        }
    }

    private static class POJOActivityInboundCallsInterceptor
    implements ActivityInboundCallsInterceptor {
        private final Object activity;
        private final Method method;
        private ActivityExecutionContext context;

        private POJOActivityInboundCallsInterceptor(Object activity, Method method) {
            this.activity = activity;
            this.method = method;
        }

        @Override
        public void init(ActivityExecutionContext context) {
            this.context = context;
        }

        @Override
        public Object execute(Object[] arguments) {
            CurrentActivityExecutionContext.set(this.context);
            try {
                Object object = this.method.invoke(this.activity, arguments);
                return object;
            }
            catch (Error e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw Activity.wrap(e.getTargetException());
            }
            catch (Exception e) {
                throw Activity.wrap(e);
            }
            finally {
                CurrentActivityExecutionContext.unset();
            }
        }
    }

    private class POJOActivityImplementation
    implements ActivityTaskExecutor {
        private final Method method;
        private final Object activity;

        POJOActivityImplementation(Method interfaceMethod, Object activity) {
            this.method = interfaceMethod;
            this.activity = activity;
        }

        @Override
        public ActivityTaskHandler.Result execute(ActivityInfoImpl info, Scope metricsScope) {
            ActivityExecutionContextImpl context = new ActivityExecutionContextImpl(POJOActivityTaskHandler.this.service, POJOActivityTaskHandler.this.namespace, info, POJOActivityTaskHandler.this.dataConverter, POJOActivityTaskHandler.this.heartbeatExecutor, metricsScope);
            Optional<Payloads> input = info.getInput();
            ActivityInboundCallsInterceptor inboundCallsInterceptor = new POJOActivityInboundCallsInterceptor(this.activity, this.method);
            for (ActivityInterceptor interceptor : POJOActivityTaskHandler.this.interceptors) {
                inboundCallsInterceptor = interceptor.interceptActivity(inboundCallsInterceptor);
            }
            inboundCallsInterceptor.init(context);
            try {
                Optional<Payloads> serialized;
                Object[] args = DataConverter.arrayFromPayloads(POJOActivityTaskHandler.this.dataConverter, input, this.method.getParameterTypes(), this.method.getGenericParameterTypes());
                Object result = inboundCallsInterceptor.execute(args);
                if (context.isDoNotCompleteOnReturn()) {
                    return new ActivityTaskHandler.Result(info.getActivityId(), null, null, null, null);
                }
                RespondActivityTaskCompletedRequest.Builder request = RespondActivityTaskCompletedRequest.newBuilder();
                if (this.method.getReturnType() != Void.TYPE && (serialized = POJOActivityTaskHandler.this.dataConverter.toPayloads(result)).isPresent()) {
                    request.setResult(serialized.get());
                }
                return new ActivityTaskHandler.Result(info.getActivityId(), request.build(), null, null, null);
            }
            catch (Throwable e) {
                e = CheckedExceptionWrapper.unwrap(e);
                if (e instanceof ActivityCanceledException) {
                    if (log.isInfoEnabled()) {
                        log.info("Activity canceled. ActivityId=" + info.getActivityId() + ", activityType=" + info.getActivityType() + ", attempt=" + info.getAttempt());
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn("Activity failure. ActivityId=" + info.getActivityId() + ", activityType=" + info.getActivityType() + ", attempt=" + info.getAttempt(), e);
                }
                return POJOActivityTaskHandler.this.mapToActivityFailure(e, info.getActivityId(), metricsScope, false);
            }
        }
    }

    static interface ActivityTaskExecutor {
        public ActivityTaskHandler.Result execute(ActivityInfoImpl var1, Scope var2);
    }
}

