/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Objects;
import io.temporal.internal.sync.POJOWorkflowInterfaceMetadata;
import io.temporal.internal.sync.POJOWorkflowMethodMetadata;
import io.temporal.internal.sync.WorkflowMethodType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class POJOWorkflowImplMetadata {
    private final Map<String, POJOWorkflowMethodMetadata> workflowMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
    private final Map<String, POJOWorkflowMethodMetadata> signalMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
    private final Map<String, POJOWorkflowMethodMetadata> queryMethods = new HashMap<String, POJOWorkflowMethodMetadata>();

    public static POJOWorkflowImplMetadata newInstance(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, false);
    }

    public static POJOWorkflowImplMetadata newListenerInstance(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, true);
    }

    private POJOWorkflowImplMetadata(Class<?> implClass, boolean listener) {
        if (implClass.isInterface() || implClass.isPrimitive() || implClass.isAnnotation() || implClass.isArray() || implClass.isEnum()) {
            throw new IllegalArgumentException("concrete class expected: " + implClass);
        }
        HashMap<EqualsByNameType, POJOWorkflowMethodMetadata> byNameType = new HashMap<EqualsByNameType, POJOWorkflowMethodMetadata>();
        Class<?>[] interfaces = implClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            POJOWorkflowInterfaceMetadata interfaceMetadata = listener ? POJOWorkflowInterfaceMetadata.newInstanceSkipWorkflowAnnotationCheck(anInterface) : POJOWorkflowInterfaceMetadata.newImplementationInterface(anInterface);
            List<POJOWorkflowMethodMetadata> methods = interfaceMetadata.getMethodsMetadata();
            for (POJOWorkflowMethodMetadata methodMetadata : methods) {
                EqualsByNameType key = new EqualsByNameType(methodMetadata.getName(), methodMetadata.getType());
                POJOWorkflowMethodMetadata registeredMM = byNameType.put(key, methodMetadata);
                if (registeredMM != null && !registeredMM.getWorkflowMethod().equals(methodMetadata.getWorkflowMethod())) {
                    throw new IllegalArgumentException("Duplicated name of " + (Object)((Object)methodMetadata.getType()) + ": \"" + methodMetadata.getName() + "\" declared at \"" + registeredMM.getWorkflowMethod() + "\" and \"" + methodMetadata.getWorkflowMethod() + "\"");
                }
                switch (methodMetadata.getType()) {
                    case WORKFLOW: {
                        this.workflowMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case SIGNAL: {
                        this.signalMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case QUERY: {
                        this.queryMethods.put(methodMetadata.getName(), methodMetadata);
                    }
                }
            }
        }
        if (byNameType.isEmpty() && !listener) {
            throw new IllegalArgumentException("Class doesn't implement any non empty public interface annotated with @WorkflowInterface: " + implClass.getName());
        }
    }

    public Set<String> getWorkflowTypes() {
        return this.workflowMethods.keySet();
    }

    public POJOWorkflowMethodMetadata getWorkflowMethodMetadata(String workflowType) {
        POJOWorkflowMethodMetadata result = this.workflowMethods.get(workflowType);
        if (result == null) {
            throw new IllegalArgumentException("Unknown workflow type: " + workflowType);
        }
        return result;
    }

    public Set<String> getSignalTypes() {
        return this.signalMethods.keySet();
    }

    public POJOWorkflowMethodMetadata getSignalMethodMetadata(String signalType) {
        POJOWorkflowMethodMetadata result = this.signalMethods.get(signalType);
        if (result == null) {
            throw new IllegalArgumentException("Unknown signal type \"" + signalType + "\", registeredSignals are: \"" + String.join((CharSequence)", ", this.signalMethods.keySet()) + "\"");
        }
        return result;
    }

    public Set<String> getQueryTypes() {
        return this.queryMethods.keySet();
    }

    public POJOWorkflowMethodMetadata getQueryMethodMetadata(String queryType) {
        POJOWorkflowMethodMetadata result = this.queryMethods.get(queryType);
        if (result == null) {
            throw new IllegalArgumentException("Unknown query type: " + queryType);
        }
        return result;
    }

    static class EqualsByNameType {
        private final String name;
        private final WorkflowMethodType type;

        EqualsByNameType(String name, WorkflowMethodType type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByNameType that = (EqualsByNameType)o;
            return Objects.equal((Object)this.name, (Object)that.name) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type});
        }
    }
}

