/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.POJOWorkflowMethod;
import io.temporal.internal.sync.WorkflowMethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

class POJOWorkflowMethodMetadata {
    private final POJOWorkflowMethod workflowMethod;
    private final String name;
    private final Class<?> interfaceType;

    public POJOWorkflowMethodMetadata(POJOWorkflowMethod methodMetadata, Class<?> interfaceType) {
        this.workflowMethod = Objects.requireNonNull(methodMetadata);
        if (this.workflowMethod.getType() == WorkflowMethodType.NONE) {
            throw new IllegalArgumentException("Method \"" + methodMetadata.getMethod().getName() + "\" is not annotated with @WorkflowMethod, @SignalMethod or @QueryMethod");
        }
        this.interfaceType = Objects.requireNonNull(interfaceType);
        Optional<String> nameFromAnnotation = this.workflowMethod.getNameFromAnnotation();
        this.name = this.workflowMethod.getType() == WorkflowMethodType.WORKFLOW ? nameFromAnnotation.orElse(interfaceType.getSimpleName()) : nameFromAnnotation.orElse(methodMetadata.getMethod().getName());
    }

    public WorkflowMethodType getType() {
        return this.workflowMethod.getType();
    }

    public String getName() {
        return this.name;
    }

    public Method getWorkflowMethod() {
        return this.workflowMethod.getMethod();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        POJOWorkflowMethodMetadata that = (POJOWorkflowMethodMetadata)o;
        return com.google.common.base.Objects.equal((Object)this.workflowMethod, (Object)that.workflowMethod) && com.google.common.base.Objects.equal(this.interfaceType, that.interfaceType);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.workflowMethod, this.interfaceType});
    }
}

