/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class WorkerOptions {
    private static final WorkerOptions DEFAULT_INSTANCE = WorkerOptions.newBuilder().build();
    private final double maxWorkerActivitiesPerSecond;
    private final int maxConcurrentActivityExecutionSize;
    private final int maxConcurrentWorkflowTaskExecutionSize;
    private final int maxConcurrentLocalActivityExecutionSize;
    private final double maxTaskQueueActivitiesPerSecond;
    private final int workflowPollThreadCount;
    private final int activityPollThreadCount;
    private final boolean localActivityWorkerOnly;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerOptions options) {
        return new Builder(options);
    }

    public static WorkerOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerOptions(double maxWorkerActivitiesPerSecond, int maxConcurrentActivityExecutionSize, int maxConcurrentWorkflowExecutionSize, int maxConcurrentLocalActivityExecutionSize, double maxTaskQueueActivitiesPerSecond, int workflowPollThreadCount, int activityPollThreadCount, boolean localActivityWorkerOnly) {
        this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
        this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
        this.maxConcurrentWorkflowTaskExecutionSize = maxConcurrentWorkflowExecutionSize;
        this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
        this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
        this.workflowPollThreadCount = workflowPollThreadCount;
        this.activityPollThreadCount = activityPollThreadCount;
        this.localActivityWorkerOnly = localActivityWorkerOnly;
    }

    public double getMaxWorkerActivitiesPerSecond() {
        return this.maxWorkerActivitiesPerSecond;
    }

    public int getMaxConcurrentActivityExecutionSize() {
        return this.maxConcurrentActivityExecutionSize;
    }

    public int getMaxConcurrentWorkflowTaskExecutionSize() {
        return this.maxConcurrentWorkflowTaskExecutionSize;
    }

    public int getMaxConcurrentLocalActivityExecutionSize() {
        return this.maxConcurrentLocalActivityExecutionSize;
    }

    public double getMaxTaskQueueActivitiesPerSecond() {
        return this.maxTaskQueueActivitiesPerSecond;
    }

    public int getWorkflowPollThreadCount() {
        return this.workflowPollThreadCount;
    }

    public int getActivityPollThreadCount() {
        return this.activityPollThreadCount;
    }

    public boolean isLocalActivityWorkerOnly() {
        return this.localActivityWorkerOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerOptions that = (WorkerOptions)o;
        return Double.compare(that.maxWorkerActivitiesPerSecond, this.maxWorkerActivitiesPerSecond) == 0 && this.maxConcurrentActivityExecutionSize == that.maxConcurrentActivityExecutionSize && this.maxConcurrentWorkflowTaskExecutionSize == that.maxConcurrentWorkflowTaskExecutionSize && this.maxConcurrentLocalActivityExecutionSize == that.maxConcurrentLocalActivityExecutionSize && Double.compare(that.maxTaskQueueActivitiesPerSecond, this.maxTaskQueueActivitiesPerSecond) == 0 && this.workflowPollThreadCount == that.workflowPollThreadCount && this.activityPollThreadCount == that.activityPollThreadCount && this.localActivityWorkerOnly == that.localActivityWorkerOnly;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.maxTaskQueueActivitiesPerSecond, this.workflowPollThreadCount, this.activityPollThreadCount, this.localActivityWorkerOnly});
    }

    public String toString() {
        return "WorkerOptions{maxWorkerActivitiesPerSecond=" + this.maxWorkerActivitiesPerSecond + ", maxConcurrentActivityExecutionSize=" + this.maxConcurrentActivityExecutionSize + ", maxConcurrentWorkflowTaskExecutionSize=" + this.maxConcurrentWorkflowTaskExecutionSize + ", maxConcurrentLocalActivityExecutionSize=" + this.maxConcurrentLocalActivityExecutionSize + ", maxTaskQueueActivitiesPerSecond=" + this.maxTaskQueueActivitiesPerSecond + ", workflowPollThreadCount=" + this.workflowPollThreadCount + ", activityPollThreadCount=" + this.activityPollThreadCount + ", localActivityWorkerOnly=" + this.localActivityWorkerOnly + '}';
    }

    public static final class Builder {
        private static final int DEFAULT_WORKFLOW_POLL_THREAD_COUNT = 2;
        private static final int DEFAULT_ACTIVITY_POLL_THREAD_COUNT = 5;
        private static final int DEFAULT_MAX_CONCURRENT_ACTIVITY_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_WORKFLOW_TASK_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_LOCAL_ACTIVITY_EXECUTION_SIZE = 200;
        private double maxWorkerActivitiesPerSecond;
        private int maxConcurrentActivityExecutionSize;
        private int maxConcurrentWorkflowTaskExecutionSize;
        private int maxConcurrentLocalActivityExecutionSize;
        private double maxTaskQueueActivitiesPerSecond;
        private int workflowPollThreadCount;
        private int activityPollThreadCount;
        private boolean localActivityWorkerOnly;

        private Builder() {
        }

        private Builder(WorkerOptions o) {
            if (o == null) {
                return;
            }
            this.maxWorkerActivitiesPerSecond = o.maxWorkerActivitiesPerSecond;
            this.maxConcurrentActivityExecutionSize = o.maxConcurrentActivityExecutionSize;
            this.maxConcurrentWorkflowTaskExecutionSize = o.maxConcurrentWorkflowTaskExecutionSize;
            this.maxConcurrentLocalActivityExecutionSize = o.maxConcurrentLocalActivityExecutionSize;
            this.maxTaskQueueActivitiesPerSecond = o.maxTaskQueueActivitiesPerSecond;
            this.workflowPollThreadCount = o.workflowPollThreadCount;
            this.activityPollThreadCount = o.activityPollThreadCount;
            this.localActivityWorkerOnly = o.localActivityWorkerOnly;
        }

        public Builder setMaxWorkerActivitiesPerSecond(double maxWorkerActivitiesPerSecond) {
            if (maxWorkerActivitiesPerSecond <= 0.0) {
                throw new IllegalArgumentException("Negative or zero: " + maxWorkerActivitiesPerSecond);
            }
            this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentActivityExecutionSize(int maxConcurrentActivityExecutionSize) {
            if (maxConcurrentActivityExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentActivityExecutionSize);
            }
            this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentWorkflowTaskExecutionSize(int maxConcurrentWorkflowTaskExecutionSize) {
            if (maxConcurrentWorkflowTaskExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentWorkflowTaskExecutionSize);
            }
            this.maxConcurrentWorkflowTaskExecutionSize = maxConcurrentWorkflowTaskExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentLocalActivityExecutionSize(int maxConcurrentLocalActivityExecutionSize) {
            if (maxConcurrentLocalActivityExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentLocalActivityExecutionSize);
            }
            this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
            return this;
        }

        public Builder setMaxTaskQueueActivitiesPerSecond(double maxTaskQueueActivitiesPerSecond) {
            this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
            return this;
        }

        public Builder setWorkflowPollThreadCount(int workflowPollThreadCount) {
            this.workflowPollThreadCount = workflowPollThreadCount;
            return this;
        }

        public Builder setActivityPollThreadCount(int activityPollThreadCount) {
            this.activityPollThreadCount = activityPollThreadCount;
            return this;
        }

        public Builder setLocalActivityWorkerOnly(boolean localActivityWorkerOnly) {
            this.localActivityWorkerOnly = localActivityWorkerOnly;
            return this;
        }

        public WorkerOptions build() {
            return new WorkerOptions(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentActivityExecutionSize, this.maxTaskQueueActivitiesPerSecond, this.workflowPollThreadCount, this.activityPollThreadCount, this.localActivityWorkerOnly);
        }

        public WorkerOptions validateAndBuildWithDefaults() {
            Preconditions.checkState((this.maxWorkerActivitiesPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"negative maxActivitiesPerSecond");
            Preconditions.checkState((this.maxConcurrentActivityExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentActivityExecutionSize");
            Preconditions.checkState((this.maxConcurrentWorkflowTaskExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentWorkflowTaskExecutionSize");
            Preconditions.checkState((this.maxConcurrentLocalActivityExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentLocalActivityExecutionSize");
            Preconditions.checkState((this.maxTaskQueueActivitiesPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"negative taskQueueActivitiesPerSecond");
            Preconditions.checkState((this.workflowPollThreadCount >= 0 ? 1 : 0) != 0, (Object)"negative workflowPollThreadCount");
            Preconditions.checkState((this.activityPollThreadCount >= 0 ? 1 : 0) != 0, (Object)"negative activityPollThreadCount");
            return new WorkerOptions(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize == 0 ? 200 : this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize == 0 ? 200 : this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize == 0 ? 200 : this.maxConcurrentLocalActivityExecutionSize, this.maxTaskQueueActivitiesPerSecond, this.workflowPollThreadCount == 0 ? 2 : this.workflowPollThreadCount, this.activityPollThreadCount == 0 ? 5 : this.activityPollThreadCount, this.localActivityWorkerOnly);
        }
    }
}

