/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.enums.v1.QueryRejectCondition;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class WorkflowClientOptions {
    private static final WorkflowClientOptions DEFAULT_INSTANCE = WorkflowClientOptions.newBuilder().build();
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String DEFAULT_BINARY_CHECKSUM = "";
    private static final WorkflowClientInterceptor[] EMPTY_INTERCEPTOR_ARRAY = new WorkflowClientInterceptor[0];
    private static final List<ContextPropagator> EMPTY_CONTEXT_PROPAGATORS = Collections.emptyList();
    private final String namespace;
    private final DataConverter dataConverter;
    private final WorkflowClientInterceptor[] interceptors;
    private final String identity;
    private final String binaryChecksum;
    private final List<ContextPropagator> contextPropagators;
    private final QueryRejectCondition queryRejectCondition;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowClientOptions options) {
        return new Builder(options);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkflowClientOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkflowClientOptions(String namespace, DataConverter dataConverter, WorkflowClientInterceptor[] interceptors, String identity, String binaryChecksum, List<ContextPropagator> contextPropagators, QueryRejectCondition queryRejectCondition) {
        this.namespace = namespace;
        this.dataConverter = dataConverter;
        this.interceptors = interceptors;
        this.identity = identity;
        this.binaryChecksum = binaryChecksum;
        this.contextPropagators = contextPropagators;
        this.queryRejectCondition = queryRejectCondition;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public WorkflowClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getBinaryChecksum() {
        return this.binaryChecksum;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public QueryRejectCondition getQueryRejectCondition() {
        return this.queryRejectCondition;
    }

    public String toString() {
        return "WorkflowClientOptions{namespace='" + this.namespace + '\'' + ", dataConverter=" + this.dataConverter + ", interceptors=" + Arrays.toString(this.interceptors) + ", identity='" + this.identity + '\'' + ", binaryChecksum='" + this.binaryChecksum + '\'' + ", contextPropagators=" + this.contextPropagators + ", queryRejectCondition=" + this.queryRejectCondition + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowClientOptions that = (WorkflowClientOptions)o;
        return com.google.common.base.Objects.equal((Object)this.namespace, (Object)that.namespace) && com.google.common.base.Objects.equal((Object)this.dataConverter, (Object)that.dataConverter) && Arrays.equals(this.interceptors, that.interceptors) && com.google.common.base.Objects.equal((Object)this.identity, (Object)that.identity) && com.google.common.base.Objects.equal((Object)this.binaryChecksum, (Object)that.binaryChecksum) && com.google.common.base.Objects.equal(this.contextPropagators, that.contextPropagators) && this.queryRejectCondition == that.queryRejectCondition;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.namespace, this.dataConverter, Arrays.hashCode(this.interceptors), this.identity, this.binaryChecksum, this.contextPropagators, this.queryRejectCondition});
    }

    public static final class Builder {
        private String namespace;
        private DataConverter dataConverter;
        private WorkflowClientInterceptor[] interceptors;
        private String identity;
        private String binaryChecksum;
        private List<ContextPropagator> contextPropagators;
        private QueryRejectCondition queryRejectCondition;

        private Builder() {
        }

        private Builder(WorkflowClientOptions options) {
            if (options == null) {
                return;
            }
            this.namespace = options.namespace;
            this.dataConverter = options.dataConverter;
            this.interceptors = options.interceptors;
            this.identity = options.identity;
            this.binaryChecksum = options.binaryChecksum;
            this.contextPropagators = options.contextPropagators;
            this.queryRejectCondition = options.queryRejectCondition;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = Objects.requireNonNull(dataConverter);
            return this;
        }

        public Builder setInterceptors(WorkflowClientInterceptor ... interceptors) {
            this.interceptors = Objects.requireNonNull(interceptors);
            return this;
        }

        public Builder setIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder setBinaryChecksum(String binaryChecksum) {
            this.binaryChecksum = binaryChecksum;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setQueryRejectCondition(QueryRejectCondition queryRejectCondition) {
            this.queryRejectCondition = queryRejectCondition;
            return this;
        }

        public WorkflowClientOptions build() {
            return new WorkflowClientOptions(this.namespace, this.dataConverter, this.interceptors, this.identity, this.binaryChecksum, this.contextPropagators, this.queryRejectCondition);
        }

        public WorkflowClientOptions validateAndBuildWithDefaults() {
            String name = this.identity == null ? ManagementFactory.getRuntimeMXBean().getName() : this.identity;
            return new WorkflowClientOptions(this.namespace == null ? WorkflowClientOptions.DEFAULT_NAMESPACE : this.namespace, this.dataConverter == null ? DataConverter.getDefaultInstance() : this.dataConverter, this.interceptors == null ? EMPTY_INTERCEPTOR_ARRAY : this.interceptors, name, this.binaryChecksum == null ? WorkflowClientOptions.DEFAULT_BINARY_CHECKSUM : this.binaryChecksum, this.contextPropagators == null ? EMPTY_CONTEXT_PROPAGATORS : this.contextPropagators, this.queryRejectCondition == null ? QueryRejectCondition.QUERY_REJECT_CONDITION_UNSPECIFIED : this.queryRejectCondition);
        }
    }
}

