/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.ByteArrayPayloadConverter;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.JacksonJsonPayloadConverter;
import io.temporal.common.converter.NullPayloadConverter;
import io.temporal.common.converter.PayloadConverter;
import io.temporal.common.converter.ProtobufJsonPayloadConverter;
import io.temporal.common.converter.ProtobufPayloadConverter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultDataConverter
implements DataConverter {
    private static final PayloadConverter[] DEFAULT_PAYLOAD_CONVERTERS = new PayloadConverter[]{new NullPayloadConverter(), new ByteArrayPayloadConverter(), new ProtobufJsonPayloadConverter(), new ProtobufPayloadConverter(), new JacksonJsonPayloadConverter()};
    private static final AtomicReference<DataConverter> defaultDataConverterInstance = new AtomicReference<DefaultDataConverter>(DefaultDataConverter.newDefaultInstance());
    private final Map<String, PayloadConverter> converterMap = new ConcurrentHashMap<String, PayloadConverter>();
    private final List<PayloadConverter> converters = new ArrayList<PayloadConverter>();

    static DataConverter getDefaultInstance() {
        return defaultDataConverterInstance.get();
    }

    public static void setDefaultDataConverter(DataConverter converter) {
        defaultDataConverterInstance.set(converter);
    }

    public static DefaultDataConverter newDefaultInstance() {
        return new DefaultDataConverter(DEFAULT_PAYLOAD_CONVERTERS);
    }

    public DefaultDataConverter(PayloadConverter ... converters) {
        Collections.addAll(this.converters, converters);
        this.updateConverterMap();
    }

    public DefaultDataConverter withPayloadConverterOverrides(PayloadConverter ... overrideConverters) {
        for (PayloadConverter overrideConverter : overrideConverters) {
            PayloadConverter existingConverter = this.converterMap.get(overrideConverter.getEncodingType());
            if (existingConverter != null) {
                int existingConverterIndex = this.converters.indexOf(existingConverter);
                this.converters.set(existingConverterIndex, overrideConverter);
                continue;
            }
            this.converters.add(overrideConverter);
        }
        this.updateConverterMap();
        return this;
    }

    @Override
    public <T> Optional<Payload> toPayload(T value) {
        for (PayloadConverter converter : this.converters) {
            Optional<Payload> result = converter.toData(value);
            if (!result.isPresent()) continue;
            return result;
        }
        throw new IllegalArgumentException("Failure serializing " + value);
    }

    @Override
    public <T> T fromPayload(Payload payload, Class<T> valueClass, Type valueType) {
        try {
            String encoding = payload.getMetadataOrThrow("encoding").toString(StandardCharsets.UTF_8);
            PayloadConverter converter = this.converterMap.get(encoding);
            if (converter == null) {
                throw new IllegalArgumentException("Unknown encoding: " + encoding);
            }
            return converter.fromData(payload, valueClass, valueType);
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataConverterException(payload, valueClass, (Throwable)e);
        }
    }

    @Override
    public Optional<Payloads> toPayloads(Object ... values) throws DataConverterException {
        if (values == null || values.length == 0) {
            return Optional.empty();
        }
        try {
            Payloads.Builder result = Payloads.newBuilder();
            for (Object value : values) {
                Optional<Payload> payload = this.toPayload(value);
                if (payload.isPresent()) {
                    result.addPayloads(payload.get());
                    continue;
                }
                result.addPayloads(Payload.getDefaultInstance());
            }
            return Optional.of(result.build());
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromPayloads(int index, Optional<Payloads> content, Class<T> parameterType, Type genericParameterType) throws DataConverterException {
        if (!content.isPresent()) {
            return (T)Defaults.defaultValue(parameterType);
        }
        int count = content.get().getPayloadsCount();
        if (index >= count) {
            return (T)Defaults.defaultValue(parameterType);
        }
        return this.fromPayload(content.get().getPayloads(index), parameterType, genericParameterType);
    }

    private void updateConverterMap() {
        this.converterMap.clear();
        for (PayloadConverter converter : this.converters) {
            this.converterMap.put(converter.getEncodingType(), converter);
        }
    }
}

