/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.interceptors;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.client.WorkflowOptions;
import io.temporal.common.Experimental;
import io.temporal.common.interceptors.Header;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

@Experimental
public interface WorkflowClientCallsInterceptor {
    public WorkflowStartOutput start(WorkflowStartInput var1);

    public WorkflowSignalOutput signal(WorkflowSignalInput var1);

    public WorkflowSignalWithStartOutput signalWithStart(WorkflowSignalWithStartInput var1);

    public <R> GetResultOutput<R> getResult(GetResultInput<R> var1) throws TimeoutException;

    public <R> GetResultAsyncOutput<R> getResultAsync(GetResultInput<R> var1);

    public <R> QueryOutput<R> query(QueryInput<R> var1);

    public CancelOutput cancel(CancelInput var1);

    public TerminateOutput terminate(TerminateInput var1);

    public static final class TerminateOutput {
    }

    public static final class TerminateInput {
        private final WorkflowExecution workflowExecution;
        @Nullable
        private final String reason;
        private final Object[] details;

        public TerminateInput(WorkflowExecution workflowExecution, @Nullable String reason, Object[] details) {
            this.workflowExecution = workflowExecution;
            this.reason = reason;
            this.details = details;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public Object[] getDetails() {
            return this.details;
        }
    }

    public static final class CancelOutput {
    }

    public static final class CancelInput {
        private final WorkflowExecution workflowExecution;

        public CancelInput(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }
    }

    public static final class QueryOutput<R> {
        private final WorkflowExecutionStatus queryRejectedStatus;
        private final R result;

        public QueryOutput(WorkflowExecutionStatus queryRejectedStatus, R result) {
            this.queryRejectedStatus = queryRejectedStatus;
            this.result = result;
        }

        public boolean isQueryRejected() {
            return this.queryRejectedStatus != null;
        }

        public WorkflowExecutionStatus getQueryRejectedStatus() {
            return this.queryRejectedStatus;
        }

        public R getResult() {
            return this.result;
        }
    }

    public static final class QueryInput<R> {
        private final WorkflowExecution workflowExecution;
        private final String queryType;
        private final Object[] arguments;
        private final Class<R> resultClass;
        private final Type resultType;

        public QueryInput(WorkflowExecution workflowExecution, String queryType, Object[] arguments, Class<R> resultClass, Type resultType) {
            this.workflowExecution = workflowExecution;
            this.queryType = queryType;
            this.arguments = arguments;
            this.resultClass = resultClass;
            this.resultType = resultType;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }
    }

    public static final class GetResultAsyncOutput<R> {
        private final CompletableFuture<R> result;

        public GetResultAsyncOutput(CompletableFuture<R> result) {
            this.result = result;
        }

        public CompletableFuture<R> getResult() {
            return this.result;
        }
    }

    public static final class GetResultOutput<R> {
        private final R result;

        public GetResultOutput(R result) {
            this.result = result;
        }

        public R getResult() {
            return this.result;
        }
    }

    public static final class GetResultInput<R> {
        private final WorkflowExecution workflowExecution;
        private final Optional<String> workflowType;
        private final long timeout;
        private final TimeUnit timeoutUnit;
        private final Class<R> resultClass;
        private final Type resultType;

        public GetResultInput(WorkflowExecution workflowExecution, Optional<String> workflowType, long timeout, TimeUnit timeoutUnit, Class<R> resultClass, Type resultType) {
            this.workflowExecution = workflowExecution;
            this.workflowType = workflowType;
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            this.resultClass = resultClass;
            this.resultType = resultType;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public Optional<String> getWorkflowType() {
            return this.workflowType;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public TimeUnit getTimeoutUnit() {
            return this.timeoutUnit;
        }

        public Class<R> getResultClass() {
            return this.resultClass;
        }

        public Type getResultType() {
            return this.resultType;
        }
    }

    public static final class WorkflowSignalWithStartOutput {
        private final WorkflowStartOutput workflowStartOutput;

        public WorkflowSignalWithStartOutput(WorkflowStartOutput workflowStartOutput) {
            this.workflowStartOutput = workflowStartOutput;
        }

        public WorkflowStartOutput getWorkflowStartOutput() {
            return this.workflowStartOutput;
        }
    }

    public static final class WorkflowSignalWithStartInput {
        private final WorkflowStartInput workflowStartInput;
        private final String signalName;
        private final Object[] signalArguments;

        public WorkflowSignalWithStartInput(WorkflowStartInput workflowStartInput, String signalName, Object[] signalArguments) {
            this.workflowStartInput = workflowStartInput;
            this.signalName = signalName;
            this.signalArguments = signalArguments;
        }

        public WorkflowStartInput getWorkflowStartInput() {
            return this.workflowStartInput;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Object[] getSignalArguments() {
            return this.signalArguments;
        }
    }

    public static final class WorkflowSignalOutput {
    }

    public static final class WorkflowSignalInput {
        private final WorkflowExecution workflowExecution;
        private final String signalName;
        private final Object[] arguments;

        public WorkflowSignalInput(WorkflowExecution workflowExecution, String signalName, Object[] signalArguments) {
            this.workflowExecution = workflowExecution;
            this.signalName = signalName;
            this.arguments = signalArguments;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public Object[] getArguments() {
            return this.arguments;
        }
    }

    public static final class WorkflowStartOutput {
        private final WorkflowExecution workflowExecution;

        public WorkflowStartOutput(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }
    }

    public static final class WorkflowStartInput {
        private final String workflowId;
        private final String workflowType;
        private final Header header;
        private final Object[] arguments;
        private final WorkflowOptions options;

        public WorkflowStartInput(String workflowId, String workflowType, Header header, Object[] arguments, WorkflowOptions options) {
            this.workflowId = workflowId;
            this.workflowType = workflowType;
            this.header = header;
            this.arguments = arguments;
            this.options = options;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public String getWorkflowType() {
            return this.workflowType;
        }

        public Header getHeader() {
            return this.header;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public WorkflowOptions getOptions() {
            return this.options;
        }
    }
}

