/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client.external;

import com.google.common.util.concurrent.ListenableFuture;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.grpc.Deadline;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.rpcretry.DefaultStubLongPollRpcRetryOptions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public final class GenericWorkflowClientImpl
implements GenericWorkflowClient {
    private final WorkflowServiceStubs service;
    private final Scope metricsScope;

    public GenericWorkflowClientImpl(WorkflowServiceStubs service, Scope metricsScope) {
        this.service = service;
        this.metricsScope = metricsScope;
    }

    @Override
    public WorkflowExecution start(StartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        StartWorkflowExecutionResponse result = (StartWorkflowExecutionResponse)GrpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).startWorkflowExecution(request), (RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()));
        return WorkflowExecution.newBuilder().setRunId(result.getRunId()).setWorkflowId(request.getWorkflowId()).build();
    }

    @Override
    public void signal(SignalWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        GrpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWorkflowExecution(request), (RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()));
    }

    @Override
    public WorkflowExecution signalWithStart(SignalWithStartWorkflowExecutionRequest request) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"workflow_type", (Object)request.getWorkflowType().getName()).put((Object)"task_queue", (Object)request.getTaskQueue().getName()).put((Object)"signal_name", (Object)request.getSignalName()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        SignalWithStartWorkflowExecutionResponse result = (SignalWithStartWorkflowExecutionResponse)GrpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).signalWithStartWorkflowExecution(request), (RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()));
        return WorkflowExecution.newBuilder().setRunId(result.getRunId()).setWorkflowId(request.getWorkflowId()).build();
    }

    @Override
    public void requestCancel(RequestCancelWorkflowExecutionRequest request) {
        GrpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).requestCancelWorkflowExecution(request), (RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()));
    }

    @Override
    public void terminate(TerminateWorkflowExecutionRequest request) {
        GrpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).terminateWorkflowExecution(request), (RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()));
    }

    @Override
    public GetWorkflowExecutionHistoryResponse longPollHistory(@Nonnull GetWorkflowExecutionHistoryRequest request, @Nonnull Deadline deadline) {
        return (GetWorkflowExecutionHistoryResponse)GrpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(deadline)).getWorkflowExecutionHistory(request), (GrpcRetryer.GrpcRetryerOptions)new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public CompletableFuture<GetWorkflowExecutionHistoryResponse> longPollHistoryAsync(@Nonnull GetWorkflowExecutionHistoryRequest request, @Nonnull Deadline deadline) {
        return GrpcRetryer.retryWithResultAsync(() -> {
            CompletableFuture result = new CompletableFuture();
            ListenableFuture resultFuture = ((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).withOption(MetricsTag.HISTORY_LONG_POLL_CALL_OPTIONS_KEY, (Object)true)).withDeadline(deadline)).getWorkflowExecutionHistory(request);
            resultFuture.addListener(() -> {
                try {
                    result.complete((GetWorkflowExecutionHistoryResponse)resultFuture.get());
                }
                catch (ExecutionException e) {
                    result.completeExceptionally(e.getCause());
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            }, (Executor)ForkJoinPool.commonPool());
            return result;
        }, (GrpcRetryer.GrpcRetryerOptions)new GrpcRetryer.GrpcRetryerOptions(DefaultStubLongPollRpcRetryOptions.INSTANCE, deadline));
    }

    @Override
    public QueryWorkflowResponse query(QueryWorkflowRequest queryParameters) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"query_type", (Object)queryParameters.getQuery().getQueryType()).build();
        Scope scope = this.metricsScope.tagged((Map)tags);
        return (QueryWorkflowResponse)GrpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)scope)).queryWorkflow(queryParameters), (RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()));
    }
}

