/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client.external;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.client.external.ManualActivityCompletionClientImpl;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;

class ManualActivityCompletionClientFactoryImpl
implements ManualActivityCompletionClientFactory {
    private final WorkflowServiceStubs service;
    private final DataConverter dataConverter;
    private final String namespace;
    private final String identity;

    public ManualActivityCompletionClientFactoryImpl(WorkflowServiceStubs service, String namespace, String identity, DataConverter dataConverter) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.identity = Objects.requireNonNull(identity);
        this.dataConverter = Objects.requireNonNull(dataConverter);
    }

    public WorkflowServiceStubs getService() {
        return this.service;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    @Override
    public ManualActivityCompletionClient getClient(byte[] taskToken, Scope metricsScope) {
        if (this.service == null) {
            throw new IllegalStateException("required property service is null");
        }
        if (this.dataConverter == null) {
            throw new IllegalStateException("required property dataConverter is null");
        }
        if (taskToken == null || taskToken.length == 0) {
            throw new IllegalArgumentException("null or empty task token");
        }
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, this.identity, taskToken, this.dataConverter, metricsScope);
    }

    @Override
    public ManualActivityCompletionClient getClient(WorkflowExecution execution, String activityId, Scope metricsScope) {
        if (execution == null) {
            throw new IllegalArgumentException("null execution");
        }
        if (activityId == null) {
            throw new IllegalArgumentException("null activityId");
        }
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, this.identity, execution, activityId, this.dataConverter, metricsScope);
    }
}

