/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.temporal.internal.common.ProtoEnumNameUtils;
import java.util.function.BiFunction;

class HistoryJsonUtils {
    private static final Configuration JSON_PATH_CONFIGURATION = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();

    HistoryJsonUtils() {
    }

    public static String protoJsonToHistoryFormatJson(String protoJson) {
        return HistoryJsonUtils.convertEnumValues(protoJson, ProtoEnumNameUtils::uniqueToSimplifiedName);
    }

    public static String historyFormatJsonToProtoJson(String historyFormatJson) {
        return HistoryJsonUtils.convertEnumValues(historyFormatJson, ProtoEnumNameUtils::simplifiedToUniqueName);
    }

    private static String convertEnumValues(String json, BiFunction<String, String, String> convertEnumValue) {
        DocumentContext parsed = JsonPath.parse((String)json, (Configuration)JSON_PATH_CONFIGURATION);
        for (EnumValueConversionPolicy policy : EnumValueConversionPolicy.values()) {
            for (JsonPath jsonPath : policy.jsonPaths) {
                parsed.map(jsonPath, (currentValue, configuration) -> convertEnumValue.apply((String)currentValue, policy.protobufEnumPrefix));
            }
        }
        return parsed.jsonString();
    }

    private static enum EnumValueConversionPolicy {
        EVENT_TYPE("EVENT_TYPE_", JsonPath.compile((String)"$.events.*.eventType", (Predicate[])new Predicate[0])),
        TASK_QUEUE_KIND("TASK_QUEUE_KIND_", JsonPath.compile((String)"$.events.*.*.taskQueue.kind", (Predicate[])new Predicate[0])),
        PARENT_CLOSE_POLICY("PARENT_CLOSE_POLICY_", JsonPath.compile((String)"$.events.*.*.parentClosePolicy", (Predicate[])new Predicate[0])),
        WORKFLOW_ID_REUSE_POLICY("WORKFLOW_ID_REUSE_POLICY_", JsonPath.compile((String)"$.events.*.*.workflowIdReusePolicy", (Predicate[])new Predicate[0])),
        INITIATOR("CONTINUE_AS_NEW_INITIATOR_", JsonPath.compile((String)"$.events.*.*.initiator", (Predicate[])new Predicate[0])),
        RETRY_STATE("RETRY_STATE_", JsonPath.compile((String)"$.events.*.*.retryState", (Predicate[])new Predicate[0]), JsonPath.compile((String)"$.events.*.*.*.retryState", (Predicate[])new Predicate[0]));

        private final String protobufEnumPrefix;
        private final JsonPath[] jsonPaths;

        private EnumValueConversionPolicy(String protobufEnumPrefix, JsonPath ... jsonPaths) {
            this.jsonPaths = jsonPaths;
            this.protobufEnumPrefix = protobufEnumPrefix;
        }
    }
}

