/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.ActivityCompletionException;
import io.temporal.internal.client.external.ManualActivityCompletionClientFactory;
import io.temporal.workflow.Functions;
import java.util.Optional;

class ActivityCompletionClientImpl
implements ActivityCompletionClient {
    private final ManualActivityCompletionClientFactory factory;
    private final Functions.Proc completionHandle;
    private final Scope metricsScope;

    public ActivityCompletionClientImpl(ManualActivityCompletionClientFactory manualActivityCompletionClientFactory, Functions.Proc completionHandle, Scope metricsScope) {
        this.factory = manualActivityCompletionClientFactory;
        this.completionHandle = completionHandle;
        this.metricsScope = metricsScope;
    }

    @Override
    public <R> void complete(byte[] taskToken, R result) {
        try {
            this.factory.getClient(taskToken, this.metricsScope).complete(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void complete(String workflowId, Optional<String> runId, String activityId, R result) {
        try {
            this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId, this.metricsScope).complete(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public void completeExceptionally(byte[] taskToken, Exception result) {
        try {
            this.factory.getClient(taskToken, this.metricsScope).fail(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeExceptionally(String workflowId, Optional<String> runId, String activityId, Exception result) {
        try {
            this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId, this.metricsScope).fail(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public <V> void reportCancellation(byte[] taskToken, V details) {
        try {
            this.factory.getClient(taskToken, this.metricsScope).reportCancellation(details);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> void reportCancellation(String workflowId, Optional<String> runId, String activityId, V details) {
        try {
            this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId, this.metricsScope).reportCancellation(details);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public <V> void heartbeat(byte[] taskToken, V details) throws ActivityCompletionException {
        this.factory.getClient(taskToken, this.metricsScope).recordHeartbeat(details);
    }

    @Override
    public <V> void heartbeat(String workflowId, Optional<String> runId, String activityId, V details) throws ActivityCompletionException {
        this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId, this.metricsScope).recordHeartbeat(details);
    }

    private static WorkflowExecution toExecution(String workflowId, Optional<String> runId) {
        return WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
    }
}

