/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.LocalActivityWorker;
import io.temporal.internal.worker.Poller;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalActivityPollTask
implements Poller.PollTask<LocalActivityWorker.Task>,
BiFunction<LocalActivityWorker.Task, Duration, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(LocalActivityPollTask.class);
    private static final int QUEUE_SIZE = 1000;
    private final BlockingQueue<LocalActivityWorker.Task> pendingTasks = new ArrayBlockingQueue<LocalActivityWorker.Task>(1000);

    LocalActivityPollTask() {
    }

    @Override
    public LocalActivityWorker.Task poll() {
        try {
            LocalActivityWorker.Task task = this.pendingTasks.take();
            if (log.isTraceEnabled()) {
                log.trace("LocalActivity Task poll returned: " + task.getActivityId());
            }
            return task;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public Boolean apply(LocalActivityWorker.Task task, Duration maxWaitAllowed) {
        try {
            boolean accepted = this.pendingTasks.offer(task, maxWaitAllowed.toMillis(), TimeUnit.MILLISECONDS);
            if (log.isTraceEnabled()) {
                if (accepted) {
                    log.trace("LocalActivity queued: " + task.getActivityId());
                } else {
                    log.trace("LocalActivity queue timed out for " + task.getActivityId() + " maxWaitAllowed=" + maxWaitAllowed);
                }
            }
            return accepted;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

