/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PollerOptions {
    public static final String UNHANDLED_COMMAND_EXCEPTION_MESSAGE = "Failed workflow task due to unhandled command. This error is likely recoverable.";
    private static final PollerOptions DEFAULT_INSTANCE = PollerOptions.newBuilder().build();
    private static final Logger log = LoggerFactory.getLogger(PollerOptions.class);
    private final int maximumPollRateIntervalMilliseconds;
    private final double maximumPollRatePerSecond;
    private final double pollBackoffCoefficient;
    private final Duration pollBackoffInitialInterval;
    private final Duration pollBackoffMaximumInterval;
    private final int pollThreadCount;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String pollThreadNamePrefix;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PollerOptions options) {
        return new Builder(options);
    }

    public static PollerOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private PollerOptions(int maximumPollRateIntervalMilliseconds, double maximumPollRatePerSecond, double pollBackoffCoefficient, Duration pollBackoffInitialInterval, Duration pollBackoffMaximumInterval, int pollThreadCount, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String pollThreadNamePrefix) {
        this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
        this.maximumPollRatePerSecond = maximumPollRatePerSecond;
        this.pollBackoffCoefficient = pollBackoffCoefficient;
        this.pollBackoffInitialInterval = pollBackoffInitialInterval;
        this.pollBackoffMaximumInterval = pollBackoffMaximumInterval;
        this.pollThreadCount = pollThreadCount;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.pollThreadNamePrefix = pollThreadNamePrefix;
    }

    public int getMaximumPollRateIntervalMilliseconds() {
        return this.maximumPollRateIntervalMilliseconds;
    }

    public double getMaximumPollRatePerSecond() {
        return this.maximumPollRatePerSecond;
    }

    public double getPollBackoffCoefficient() {
        return this.pollBackoffCoefficient;
    }

    public Duration getPollBackoffInitialInterval() {
        return this.pollBackoffInitialInterval;
    }

    public Duration getPollBackoffMaximumInterval() {
        return this.pollBackoffMaximumInterval;
    }

    public int getPollThreadCount() {
        return this.pollThreadCount;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public String getPollThreadNamePrefix() {
        return this.pollThreadNamePrefix;
    }

    public String toString() {
        return "PollerOptions{maximumPollRateIntervalMilliseconds=" + this.maximumPollRateIntervalMilliseconds + ", maximumPollRatePerSecond=" + this.maximumPollRatePerSecond + ", pollBackoffCoefficient=" + this.pollBackoffCoefficient + ", pollBackoffInitialInterval=" + this.pollBackoffInitialInterval + ", pollBackoffMaximumInterval=" + this.pollBackoffMaximumInterval + ", pollThreadCount=" + this.pollThreadCount + ", pollThreadNamePrefix='" + this.pollThreadNamePrefix + '\'' + '}';
    }

    public static final class Builder {
        private int maximumPollRateIntervalMilliseconds = 1000;
        private double maximumPollRatePerSecond;
        private double pollBackoffCoefficient = 2.0;
        private Duration pollBackoffInitialInterval = Duration.ofMillis(100L);
        private Duration pollBackoffMaximumInterval = Duration.ofMinutes(1L);
        private int pollThreadCount = 1;
        private String pollThreadNamePrefix;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        private Builder() {
        }

        private Builder(PollerOptions options) {
            if (options == null) {
                return;
            }
            this.maximumPollRateIntervalMilliseconds = options.getMaximumPollRateIntervalMilliseconds();
            this.maximumPollRatePerSecond = options.getMaximumPollRatePerSecond();
            this.pollBackoffCoefficient = options.getPollBackoffCoefficient();
            this.pollBackoffInitialInterval = options.getPollBackoffInitialInterval();
            this.pollBackoffMaximumInterval = options.getPollBackoffMaximumInterval();
            this.pollThreadCount = options.getPollThreadCount();
            this.pollThreadNamePrefix = options.getPollThreadNamePrefix();
            this.uncaughtExceptionHandler = options.getUncaughtExceptionHandler();
        }

        public Builder setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
            this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
            return this;
        }

        public Builder setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
            this.maximumPollRatePerSecond = maximumPollRatePerSecond;
            return this;
        }

        public Builder setPollBackoffCoefficient(double pollBackoffCoefficient) {
            this.pollBackoffCoefficient = pollBackoffCoefficient;
            return this;
        }

        public Builder setPollBackoffInitialInterval(Duration pollBackoffInitialInterval) {
            this.pollBackoffInitialInterval = pollBackoffInitialInterval;
            return this;
        }

        public Builder setPollBackoffMaximumInterval(Duration pollBackoffMaximumInterval) {
            this.pollBackoffMaximumInterval = pollBackoffMaximumInterval;
            return this;
        }

        public Builder setPollThreadCount(int pollThreadCount) {
            this.pollThreadCount = pollThreadCount;
            return this;
        }

        public Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public Builder setPollThreadNamePrefix(String pollThreadNamePrefix) {
            this.pollThreadNamePrefix = pollThreadNamePrefix;
            return this;
        }

        public PollerOptions build() {
            if (this.uncaughtExceptionHandler == null) {
                this.uncaughtExceptionHandler = (t, e) -> {
                    if (e instanceof RuntimeException && e.getCause() instanceof StatusRuntimeException) {
                        StatusRuntimeException sre = (StatusRuntimeException)e.getCause();
                        if (sre.getStatus().getCode() == Status.Code.INVALID_ARGUMENT && sre.getMessage().startsWith("INVALID_ARGUMENT: UnhandledCommand")) {
                            log.info(PollerOptions.UNHANDLED_COMMAND_EXCEPTION_MESSAGE, e);
                        }
                    } else {
                        log.error("uncaught exception", e);
                    }
                };
            }
            return new PollerOptions(this.maximumPollRateIntervalMilliseconds, this.maximumPollRatePerSecond, this.pollBackoffCoefficient, this.pollBackoffInitialInterval, this.pollBackoffMaximumInterval, this.pollThreadCount, this.uncaughtExceptionHandler, this.pollThreadNamePrefix);
        }
    }
}

