/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.worker.PollerOptions;
import java.time.Duration;
import java.util.List;

public final class SingleWorkerOptions {
    private final String identity;
    private final String binaryChecksum;
    private final DataConverter dataConverter;
    private final int taskExecutorThreadPoolSize;
    private final PollerOptions pollerOptions;
    private final Scope metricsScope;
    private final boolean enableLoggingInReplay;
    private final List<ContextPropagator> contextPropagators;
    private final long defaultDeadlockDetectionTimeout;
    private final Duration maxHeartbeatThrottleInterval;
    private final Duration defaultHeartbeatThrottleInterval;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SingleWorkerOptions options) {
        return new Builder(options);
    }

    private SingleWorkerOptions(String identity, String binaryChecksum, DataConverter dataConverter, int taskExecutorThreadPoolSize, PollerOptions pollerOptions, Scope metricsScope, boolean enableLoggingInReplay, List<ContextPropagator> contextPropagators, long defaultDeadlockDetectionTimeout, Duration maxHeartbeatThrottleInterval, Duration defaultHeartbeatThrottleInterval) {
        this.identity = identity;
        this.binaryChecksum = binaryChecksum;
        this.dataConverter = dataConverter;
        this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
        this.pollerOptions = pollerOptions;
        this.metricsScope = metricsScope;
        this.enableLoggingInReplay = enableLoggingInReplay;
        this.contextPropagators = contextPropagators;
        this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeout;
        this.maxHeartbeatThrottleInterval = maxHeartbeatThrottleInterval;
        this.defaultHeartbeatThrottleInterval = defaultHeartbeatThrottleInterval;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getBinaryChecksum() {
        return this.binaryChecksum;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public int getTaskExecutorThreadPoolSize() {
        return this.taskExecutorThreadPoolSize;
    }

    public PollerOptions getPollerOptions() {
        return this.pollerOptions;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean getEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public long getDefaultDeadlockDetectionTimeout() {
        return this.defaultDeadlockDetectionTimeout;
    }

    public Duration getMaxHeartbeatThrottleInterval() {
        return this.maxHeartbeatThrottleInterval;
    }

    public Duration getDefaultHeartbeatThrottleInterval() {
        return this.defaultHeartbeatThrottleInterval;
    }

    public static final class Builder {
        private String identity;
        private String binaryChecksum;
        private DataConverter dataConverter;
        private int taskExecutorThreadPoolSize = 100;
        private PollerOptions pollerOptions;
        private Scope metricsScope;
        private boolean enableLoggingInReplay;
        private List<ContextPropagator> contextPropagators;
        private long defaultDeadlockDetectionTimeout;
        private Duration maxHeartbeatThrottleInterval;
        private Duration defaultHeartbeatThrottleInterval;

        private Builder() {
        }

        private Builder(SingleWorkerOptions options) {
            if (options == null) {
                return;
            }
            this.identity = options.getIdentity();
            this.binaryChecksum = options.getBinaryChecksum();
            this.dataConverter = options.getDataConverter();
            this.pollerOptions = options.getPollerOptions();
            this.taskExecutorThreadPoolSize = options.getTaskExecutorThreadPoolSize();
            this.metricsScope = options.getMetricsScope();
            this.enableLoggingInReplay = options.getEnableLoggingInReplay();
            this.contextPropagators = options.getContextPropagators();
            this.defaultDeadlockDetectionTimeout = options.getDefaultDeadlockDetectionTimeout();
            this.maxHeartbeatThrottleInterval = options.getMaxHeartbeatThrottleInterval();
            this.defaultHeartbeatThrottleInterval = options.getDefaultHeartbeatThrottleInterval();
        }

        public Builder setIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder setBinaryChecksum(String binaryChecksum) {
            this.binaryChecksum = binaryChecksum;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = dataConverter;
            return this;
        }

        public Builder setTaskExecutorThreadPoolSize(int taskExecutorThreadPoolSize) {
            this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
            return this;
        }

        public Builder setPollerOptions(PollerOptions pollerOptions) {
            this.pollerOptions = pollerOptions;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setDefaultDeadlockDetectionTimeout(long defaultDeadlockDetectionTimeout) {
            this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeout;
            return this;
        }

        public Builder setMaxHeartbeatThrottleInterval(Duration maxHeartbeatThrottleInterval) {
            this.maxHeartbeatThrottleInterval = maxHeartbeatThrottleInterval;
            return this;
        }

        public Builder setDefaultHeartbeatThrottleInterval(Duration defaultHeartbeatThrottleInterval) {
            this.defaultHeartbeatThrottleInterval = defaultHeartbeatThrottleInterval;
            return this;
        }

        public SingleWorkerOptions build() {
            Scope metricsScope;
            DataConverter dataConverter;
            PollerOptions pollerOptions = this.pollerOptions;
            if (pollerOptions == null) {
                pollerOptions = PollerOptions.newBuilder().build();
            }
            if ((dataConverter = this.dataConverter) == null) {
                dataConverter = DataConverter.getDefaultInstance();
            }
            if ((metricsScope = this.metricsScope) == null) {
                metricsScope = new NoopScope();
            }
            return new SingleWorkerOptions(this.identity, this.binaryChecksum, dataConverter, this.taskExecutorThreadPoolSize, pollerOptions, metricsScope, this.enableLoggingInReplay, this.contextPropagators, this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval);
        }
    }
}

