/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public final class WorkerOptions {
    private static final WorkerOptions DEFAULT_INSTANCE = WorkerOptions.newBuilder().validateAndBuildWithDefaults();
    private final double maxWorkerActivitiesPerSecond;
    private final int maxConcurrentActivityExecutionSize;
    private final int maxConcurrentWorkflowTaskExecutionSize;
    private final int maxConcurrentLocalActivityExecutionSize;
    private final double maxTaskQueueActivitiesPerSecond;
    private final int maxConcurrentWorkflowTaskPollers;
    private final int maxConcurrentActivityTaskPollers;
    private final boolean localActivityWorkerOnly;
    private final long defaultDeadlockDetectionTimeout;
    private final Duration maxHeartbeatThrottleInterval;
    private final Duration defaultHeartbeatThrottleInterval;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerOptions options) {
        return new Builder(options);
    }

    public static WorkerOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerOptions(double maxWorkerActivitiesPerSecond, int maxConcurrentActivityExecutionSize, int maxConcurrentWorkflowExecutionSize, int maxConcurrentLocalActivityExecutionSize, double maxTaskQueueActivitiesPerSecond, int workflowPollThreadCount, int activityPollThreadCount, boolean localActivityWorkerOnly, long defaultDeadlockDetectionTimeout, Duration maxHeartbeatThrottleInterval, Duration defaultHeartbeatThrottleInterval) {
        this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
        this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
        this.maxConcurrentWorkflowTaskExecutionSize = maxConcurrentWorkflowExecutionSize;
        this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
        this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
        this.maxConcurrentWorkflowTaskPollers = workflowPollThreadCount;
        this.maxConcurrentActivityTaskPollers = activityPollThreadCount;
        this.localActivityWorkerOnly = localActivityWorkerOnly;
        this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeout;
        this.maxHeartbeatThrottleInterval = maxHeartbeatThrottleInterval;
        this.defaultHeartbeatThrottleInterval = defaultHeartbeatThrottleInterval;
    }

    public double getMaxWorkerActivitiesPerSecond() {
        return this.maxWorkerActivitiesPerSecond;
    }

    public int getMaxConcurrentActivityExecutionSize() {
        return this.maxConcurrentActivityExecutionSize;
    }

    public int getMaxConcurrentWorkflowTaskExecutionSize() {
        return this.maxConcurrentWorkflowTaskExecutionSize;
    }

    public int getMaxConcurrentLocalActivityExecutionSize() {
        return this.maxConcurrentLocalActivityExecutionSize;
    }

    public double getMaxTaskQueueActivitiesPerSecond() {
        return this.maxTaskQueueActivitiesPerSecond;
    }

    @Deprecated
    public int getWorkflowPollThreadCount() {
        return this.getMaxConcurrentWorkflowTaskPollers();
    }

    public int getMaxConcurrentWorkflowTaskPollers() {
        return this.maxConcurrentWorkflowTaskPollers;
    }

    @Deprecated
    public int getActivityPollThreadCount() {
        return this.getMaxConcurrentActivityTaskPollers();
    }

    public int getMaxConcurrentActivityTaskPollers() {
        return this.maxConcurrentActivityTaskPollers;
    }

    public long getDefaultDeadlockDetectionTimeout() {
        return this.defaultDeadlockDetectionTimeout;
    }

    public boolean isLocalActivityWorkerOnly() {
        return this.localActivityWorkerOnly;
    }

    public Duration getMaxHeartbeatThrottleInterval() {
        return this.maxHeartbeatThrottleInterval;
    }

    public Duration getDefaultHeartbeatThrottleInterval() {
        return this.defaultHeartbeatThrottleInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerOptions that = (WorkerOptions)o;
        return Double.compare(that.maxWorkerActivitiesPerSecond, this.maxWorkerActivitiesPerSecond) == 0 && this.maxConcurrentActivityExecutionSize == that.maxConcurrentActivityExecutionSize && this.maxConcurrentWorkflowTaskExecutionSize == that.maxConcurrentWorkflowTaskExecutionSize && this.maxConcurrentLocalActivityExecutionSize == that.maxConcurrentLocalActivityExecutionSize && Double.compare(that.maxTaskQueueActivitiesPerSecond, this.maxTaskQueueActivitiesPerSecond) == 0 && this.maxConcurrentWorkflowTaskPollers == that.maxConcurrentWorkflowTaskPollers && this.maxConcurrentActivityTaskPollers == that.maxConcurrentActivityTaskPollers && this.localActivityWorkerOnly == that.localActivityWorkerOnly && this.defaultDeadlockDetectionTimeout == that.defaultDeadlockDetectionTimeout && Objects.equals(this.maxHeartbeatThrottleInterval, that.maxHeartbeatThrottleInterval) && Objects.equals(this.defaultHeartbeatThrottleInterval, that.defaultHeartbeatThrottleInterval);
    }

    public int hashCode() {
        return Objects.hash(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.maxTaskQueueActivitiesPerSecond, this.maxConcurrentWorkflowTaskPollers, this.maxConcurrentActivityTaskPollers, this.localActivityWorkerOnly, this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval);
    }

    public String toString() {
        return "WorkerOptions{maxWorkerActivitiesPerSecond=" + this.maxWorkerActivitiesPerSecond + ", maxConcurrentActivityExecutionSize=" + this.maxConcurrentActivityExecutionSize + ", maxConcurrentWorkflowTaskExecutionSize=" + this.maxConcurrentWorkflowTaskExecutionSize + ", maxConcurrentLocalActivityExecutionSize=" + this.maxConcurrentLocalActivityExecutionSize + ", maxTaskQueueActivitiesPerSecond=" + this.maxTaskQueueActivitiesPerSecond + ", maxConcurrentWorkflowTaskPollers=" + this.maxConcurrentWorkflowTaskPollers + ", maxConcurrentActivityTaskPollers=" + this.maxConcurrentActivityTaskPollers + ", localActivityWorkerOnly=" + this.localActivityWorkerOnly + ", defaultDeadlockDetectionTimeout=" + this.defaultDeadlockDetectionTimeout + ", maxHeartbeatThrottleInterval=" + this.maxHeartbeatThrottleInterval + ", defaultHeartbeatThrottleInterval=" + this.defaultHeartbeatThrottleInterval + '}';
    }

    public static final class Builder {
        private static final int DEFAULT_MAX_CONCURRENT_WORKFLOW_TASK_POLLERS = 2;
        private static final int DEFAULT_MAX_CONCURRENT_ACTIVITY_TASK_POLLERS = 5;
        private static final int DEFAULT_MAX_CONCURRENT_WORKFLOW_TASK_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_ACTIVITY_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_LOCAL_ACTIVITY_EXECUTION_SIZE = 200;
        private static final long DEFAULT_DEADLOCK_DETECTION_TIMEOUT = 1000L;
        private static final Duration DEFAULT_MAX_HEARTBEAT_THROTTLE_INTERVAL = Duration.ofSeconds(60L);
        private static final Duration DEFAULT_DEFAULT_HEARTBEAT_THROTTLE_INTERVAL = Duration.ofSeconds(30L);
        private double maxWorkerActivitiesPerSecond;
        private int maxConcurrentActivityExecutionSize;
        private int maxConcurrentWorkflowTaskExecutionSize;
        private int maxConcurrentLocalActivityExecutionSize;
        private double maxTaskQueueActivitiesPerSecond;
        private int maxConcurrentWorkflowTaskPollers;
        private int maxConcurrentActivityTaskPollers;
        private boolean localActivityWorkerOnly;
        private long defaultDeadlockDetectionTimeout;
        private Duration maxHeartbeatThrottleInterval;
        private Duration defaultHeartbeatThrottleInterval;

        private Builder() {
        }

        private Builder(WorkerOptions o) {
            if (o == null) {
                return;
            }
            this.maxWorkerActivitiesPerSecond = o.maxWorkerActivitiesPerSecond;
            this.maxConcurrentActivityExecutionSize = o.maxConcurrentActivityExecutionSize;
            this.maxConcurrentWorkflowTaskExecutionSize = o.maxConcurrentWorkflowTaskExecutionSize;
            this.maxConcurrentLocalActivityExecutionSize = o.maxConcurrentLocalActivityExecutionSize;
            this.maxTaskQueueActivitiesPerSecond = o.maxTaskQueueActivitiesPerSecond;
            this.maxConcurrentWorkflowTaskPollers = o.maxConcurrentWorkflowTaskPollers;
            this.maxConcurrentActivityTaskPollers = o.maxConcurrentActivityTaskPollers;
            this.localActivityWorkerOnly = o.localActivityWorkerOnly;
            this.defaultDeadlockDetectionTimeout = o.defaultDeadlockDetectionTimeout;
            this.maxHeartbeatThrottleInterval = o.maxHeartbeatThrottleInterval;
            this.defaultHeartbeatThrottleInterval = o.defaultHeartbeatThrottleInterval;
        }

        public Builder setMaxWorkerActivitiesPerSecond(double maxWorkerActivitiesPerSecond) {
            if (maxWorkerActivitiesPerSecond < 0.0) {
                throw new IllegalArgumentException("Negative maxWorkerActivitiesPerSecond value: " + maxWorkerActivitiesPerSecond);
            }
            this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentActivityExecutionSize(int maxConcurrentActivityExecutionSize) {
            if (maxConcurrentActivityExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentActivityExecutionSize value: " + maxConcurrentActivityExecutionSize);
            }
            this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentWorkflowTaskExecutionSize(int maxConcurrentWorkflowTaskExecutionSize) {
            if (maxConcurrentWorkflowTaskExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentWorkflowTaskExecutionSize value: " + maxConcurrentWorkflowTaskExecutionSize);
            }
            this.maxConcurrentWorkflowTaskExecutionSize = maxConcurrentWorkflowTaskExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentLocalActivityExecutionSize(int maxConcurrentLocalActivityExecutionSize) {
            if (maxConcurrentLocalActivityExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentLocalActivityExecutionSize value: " + maxConcurrentLocalActivityExecutionSize);
            }
            this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
            return this;
        }

        public Builder setMaxTaskQueueActivitiesPerSecond(double maxTaskQueueActivitiesPerSecond) {
            this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentWorkflowTaskPollers(int maxConcurrentWorkflowTaskPollers) {
            this.maxConcurrentWorkflowTaskPollers = maxConcurrentWorkflowTaskPollers;
            return this;
        }

        @Deprecated
        public Builder setWorkflowPollThreadCount(int workflowPollThreadCount) {
            return this.setMaxConcurrentWorkflowTaskPollers(workflowPollThreadCount);
        }

        public Builder setMaxConcurrentActivityTaskPollers(int maxConcurrentActivityTaskPollers) {
            this.maxConcurrentActivityTaskPollers = maxConcurrentActivityTaskPollers;
            return this;
        }

        @Deprecated
        public Builder setActivityPollThreadCount(int activityPollThreadCount) {
            return this.setMaxConcurrentActivityTaskPollers(activityPollThreadCount);
        }

        public Builder setLocalActivityWorkerOnly(boolean localActivityWorkerOnly) {
            this.localActivityWorkerOnly = localActivityWorkerOnly;
            return this;
        }

        public Builder setDefaultDeadlockDetectionTimeout(long defaultDeadlockDetectionTimeoutMs) {
            if (defaultDeadlockDetectionTimeoutMs < 0L) {
                throw new IllegalArgumentException("Negative defaultDeadlockDetectionTimeout value: " + defaultDeadlockDetectionTimeoutMs);
            }
            this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeoutMs;
            return this;
        }

        public Builder setMaxHeartbeatThrottleInterval(@Nullable Duration interval) {
            Preconditions.checkArgument((interval == null || !interval.isNegative() ? 1 : 0) != 0, (Object)("Negative maxHeartbeatThrottleInterval value: " + interval));
            this.maxHeartbeatThrottleInterval = interval;
            return this;
        }

        public Builder setDefaultHeartbeatThrottleInterval(@Nullable Duration interval) {
            Preconditions.checkArgument((interval == null || !interval.isNegative() ? 1 : 0) != 0, (Object)("Negative defaultHeartbeatThrottleInterval value: " + interval));
            this.defaultHeartbeatThrottleInterval = interval;
            return this;
        }

        public WorkerOptions build() {
            return new WorkerOptions(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.maxTaskQueueActivitiesPerSecond, this.maxConcurrentWorkflowTaskPollers, this.maxConcurrentActivityTaskPollers, this.localActivityWorkerOnly, this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval);
        }

        public WorkerOptions validateAndBuildWithDefaults() {
            Preconditions.checkState((this.maxWorkerActivitiesPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"negative maxActivitiesPerSecond");
            Preconditions.checkState((this.maxConcurrentActivityExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentActivityExecutionSize");
            Preconditions.checkState((this.maxConcurrentWorkflowTaskExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentWorkflowTaskExecutionSize");
            Preconditions.checkState((this.maxConcurrentLocalActivityExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentLocalActivityExecutionSize");
            Preconditions.checkState((this.maxTaskQueueActivitiesPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"negative taskQueueActivitiesPerSecond");
            Preconditions.checkState((this.maxConcurrentWorkflowTaskPollers >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentWorkflowTaskPollers");
            Preconditions.checkState((this.maxConcurrentActivityTaskPollers >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentActivityTaskPollers");
            Preconditions.checkState((this.defaultDeadlockDetectionTimeout >= 0L ? 1 : 0) != 0, (Object)"negative defaultDeadlockDetectionTimeout");
            return new WorkerOptions(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize == 0 ? 200 : this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize == 0 ? 200 : this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize == 0 ? 200 : this.maxConcurrentLocalActivityExecutionSize, this.maxTaskQueueActivitiesPerSecond, this.maxConcurrentWorkflowTaskPollers == 0 ? 2 : this.maxConcurrentWorkflowTaskPollers, this.maxConcurrentActivityTaskPollers == 0 ? 5 : this.maxConcurrentActivityTaskPollers, this.localActivityWorkerOnly, this.defaultDeadlockDetectionTimeout == 0L ? 1000L : this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval == null || this.maxHeartbeatThrottleInterval.isZero() ? DEFAULT_MAX_HEARTBEAT_THROTTLE_INTERVAL : this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval == null || this.defaultHeartbeatThrottleInterval.isZero() ? DEFAULT_DEFAULT_HEARTBEAT_THROTTLE_INTERVAL : this.defaultHeartbeatThrottleInterval);
        }
    }
}

