/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.payload.codec.ChainCodec;
import io.temporal.payload.codec.PayloadCodec;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CodecDataConverter
implements DataConverter,
PayloadCodec {
    private final DataConverter dataConverter;
    private final PayloadCodec codec;

    public CodecDataConverter(DataConverter dataConverter, Collection<PayloadCodec> codecs) {
        this.dataConverter = dataConverter;
        this.codec = new ChainCodec(codecs);
    }

    @Override
    public <T> Optional<Payload> toPayload(T value) {
        Optional<Payload> payload = this.dataConverter.toPayload(value);
        List<Payload> encodedPayloads = this.codec.encode(Collections.singletonList(payload.get()));
        Preconditions.checkState((encodedPayloads.size() == 1 ? 1 : 0) != 0, (Object)"Expected one encoded payload");
        return Optional.of(encodedPayloads.get(0));
    }

    @Override
    public <T> T fromPayload(Payload payload, Class<T> valueClass, Type valueType) {
        List<Payload> decodedPayload = this.codec.decode(Collections.singletonList(payload));
        Preconditions.checkState((decodedPayload.size() == 1 ? 1 : 0) != 0, (Object)"Expected one decoded payload");
        return this.dataConverter.fromPayload(decodedPayload.get(0), valueClass, valueType);
    }

    @Override
    public Optional<Payloads> toPayloads(Object ... values) throws DataConverterException {
        Optional<Payloads> payloads = this.dataConverter.toPayloads(values);
        if (payloads.isPresent()) {
            List<Payload> encodedPayloads = this.codec.encode(payloads.get().getPayloadsList());
            payloads = Optional.of(Payloads.newBuilder().addAllPayloads(encodedPayloads).build());
        }
        return payloads;
    }

    @Override
    public <T> T fromPayloads(int index, Optional<Payloads> content, Class<T> valueType, Type valueGenericType) throws DataConverterException {
        if (content.isPresent()) {
            List<Payload> decodedPayloads = this.codec.decode(content.get().getPayloadsList());
            content = Optional.of(Payloads.newBuilder().addAllPayloads(decodedPayloads).build());
        }
        return this.dataConverter.fromPayloads(index, content, valueType, valueGenericType);
    }

    @Override
    @Nonnull
    public List<Payload> encode(@Nonnull List<Payload> payloads) {
        return this.codec.encode(payloads);
    }

    @Override
    @Nonnull
    public List<Payload> decode(@Nonnull List<Payload> payloads) {
        return this.codec.decode(payloads);
    }
}

