/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.ByteArrayPayloadConverter;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.GlobalDataConverter;
import io.temporal.common.converter.JacksonJsonPayloadConverter;
import io.temporal.common.converter.NullPayloadConverter;
import io.temporal.common.converter.PayloadConverter;
import io.temporal.common.converter.ProtobufJsonPayloadConverter;
import io.temporal.common.converter.ProtobufPayloadConverter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDataConverter
implements DataConverter {
    public static final PayloadConverter[] STANDARD_PAYLOAD_CONVERTERS = new PayloadConverter[]{new NullPayloadConverter(), new ByteArrayPayloadConverter(), new ProtobufJsonPayloadConverter(), new ProtobufPayloadConverter(), new JacksonJsonPayloadConverter()};
    public static final DataConverter STANDARD_INSTANCE = DefaultDataConverter.newDefaultInstance();
    private final Map<String, PayloadConverter> converterMap = new ConcurrentHashMap<String, PayloadConverter>();
    private final List<PayloadConverter> converters = new ArrayList<PayloadConverter>();

    public static void setDefaultDataConverter(DataConverter converter) {
        GlobalDataConverter.register(converter);
    }

    public static DefaultDataConverter newDefaultInstance() {
        return new DefaultDataConverter(STANDARD_PAYLOAD_CONVERTERS);
    }

    public DefaultDataConverter(PayloadConverter ... converters) {
        Collections.addAll(this.converters, converters);
        this.updateConverterMap();
    }

    public DefaultDataConverter withPayloadConverterOverrides(PayloadConverter ... overrideConverters) {
        for (PayloadConverter overrideConverter : overrideConverters) {
            PayloadConverter existingConverter = this.converterMap.get(overrideConverter.getEncodingType());
            if (existingConverter != null) {
                int existingConverterIndex = this.converters.indexOf(existingConverter);
                this.converters.set(existingConverterIndex, overrideConverter);
                continue;
            }
            this.converters.add(overrideConverter);
        }
        this.updateConverterMap();
        return this;
    }

    @Override
    public <T> Optional<Payload> toPayload(T value) throws DataConverterException {
        for (PayloadConverter converter : this.converters) {
            Optional<Payload> result = converter.toData(value);
            if (!result.isPresent()) continue;
            return result;
        }
        throw new DataConverterException("No PayloadConverter is registered with this DataConverter that accepts value:" + value);
    }

    @Override
    public <T> T fromPayload(Payload payload, Class<T> valueClass, Type valueType) throws DataConverterException {
        try {
            String encoding = payload.getMetadataOrThrow("encoding").toString(StandardCharsets.UTF_8);
            PayloadConverter converter = this.converterMap.get(encoding);
            if (converter == null) {
                throw new DataConverterException("No PayloadConverter is registered for an encoding: " + encoding);
            }
            return converter.fromData(payload, valueClass, valueType);
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataConverterException(payload, valueClass, (Throwable)e);
        }
    }

    @Override
    public Optional<Payloads> toPayloads(Object ... values) throws DataConverterException {
        if (values == null || values.length == 0) {
            return Optional.empty();
        }
        try {
            Payloads.Builder result = Payloads.newBuilder();
            for (Object value : values) {
                result.addPayloads(this.toPayload(value).get());
            }
            return Optional.of(result.build());
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromPayloads(int index, Optional<Payloads> content, Class<T> parameterType, Type genericParameterType) throws DataConverterException {
        if (!content.isPresent()) {
            return (T)Defaults.defaultValue(parameterType);
        }
        int count = content.get().getPayloadsCount();
        if (index >= count) {
            return (T)Defaults.defaultValue(parameterType);
        }
        return this.fromPayload(content.get().getPayloads(index), parameterType, genericParameterType);
    }

    private void updateConverterMap() {
        this.converterMap.clear();
        for (PayloadConverter converter : this.converters) {
            this.converterMap.put(converter.getEncodingType(), converter);
        }
    }
}

