/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.protobuf.MessageLite;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.AbstractProtobufPayloadConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.EncodingKeys;
import io.temporal.common.converter.PayloadConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Optional;

public final class ProtobufPayloadConverter
extends AbstractProtobufPayloadConverter
implements PayloadConverter {
    public ProtobufPayloadConverter() {
    }

    public ProtobufPayloadConverter(boolean excludeProtobufMessageTypes) {
        super(excludeProtobufMessageTypes);
    }

    @Override
    public String getEncodingType() {
        return "binary/protobuf";
    }

    @Override
    public Optional<Payload> toData(Object value) throws DataConverterException {
        if (!(value instanceof MessageLite)) {
            return Optional.empty();
        }
        try {
            Payload.Builder builder = Payload.newBuilder().putMetadata("encoding", EncodingKeys.METADATA_ENCODING_PROTOBUF).setData(((MessageLite)value).toByteString());
            super.addMessageType(builder, value);
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromData(Payload content, Class<T> valueClass, Type valueType) throws DataConverterException {
        if (!MessageLite.class.isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException("Not a protobuf. valueClass=" + valueClass.getName());
        }
        try {
            Method parseFrom = valueClass.getMethod("parseFrom", ByteBuffer.class);
            Object instance = parseFrom.invoke(null, content.getData().asReadOnlyByteBuffer());
            super.checkMessageType(content, instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new DataConverterException(e);
        }
    }
}

