/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client.external;

import com.google.common.base.Preconditions;
import com.uber.m3.tally.Scope;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.client.external.ManualActivityCompletionClientImpl;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;
import javax.annotation.Nonnull;

class ManualActivityCompletionClientFactoryImpl
implements ManualActivityCompletionClientFactory {
    private final WorkflowServiceStubs service;
    private final DataConverter dataConverter;
    private final String namespace;
    private final String identity;

    ManualActivityCompletionClientFactoryImpl(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String identity, @Nonnull DataConverter dataConverter) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.identity = Objects.requireNonNull(identity);
        this.dataConverter = Objects.requireNonNull(dataConverter);
    }

    @Override
    public ManualActivityCompletionClient getClient(@Nonnull byte[] taskToken, Scope metricsScope) {
        Preconditions.checkArgument((taskToken != null && taskToken.length > 0 ? 1 : 0) != 0, (Object)"null or empty task token");
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, this.identity, taskToken, this.dataConverter, metricsScope);
    }

    @Override
    public ManualActivityCompletionClient getClient(@Nonnull WorkflowExecution execution, @Nonnull String activityId, Scope metricsScope) {
        Preconditions.checkArgument((execution != null ? 1 : 0) != 0, (Object)"null execution");
        Preconditions.checkArgument((activityId != null ? 1 : 0) != 0, (Object)"null activityId");
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, this.identity, execution, activityId, this.dataConverter, metricsScope);
    }
}

