/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.common.converter.DataConverterException;
import io.temporal.internal.common.HistoryJsonUtils;
import io.temporal.internal.common.HistoryProtoTextUtils;
import java.util.List;

public final class WorkflowExecutionHistory {
    private static final Gson GSON_PRETTY_PRINTER = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser GSON_PARSER = new JsonParser();
    private final History history;

    public WorkflowExecutionHistory(History history) {
        WorkflowExecutionHistory.checkHistory(history);
        this.history = history;
    }

    public static WorkflowExecutionHistory fromJson(String serialized) {
        String protoJson = HistoryJsonUtils.historyFormatJsonToProtoJson(serialized);
        JsonFormat.Parser parser = JsonFormat.parser().ignoringUnknownFields();
        History.Builder historyBuilder = History.newBuilder();
        try {
            parser.merge(protoJson, (Message.Builder)historyBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DataConverterException(e);
        }
        History history = historyBuilder.build();
        WorkflowExecutionHistory.checkHistory(history);
        return new WorkflowExecutionHistory(history);
    }

    private static void checkHistory(History history) {
        List events = history.getEventsList();
        if (events == null || events.size() == 0) {
            throw new IllegalArgumentException("Empty history");
        }
        HistoryEvent startedEvent = (HistoryEvent)events.get(0);
        if (startedEvent.getEventType() != EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED) {
            throw new IllegalArgumentException("First event is not WorkflowExecutionStarted but " + startedEvent);
        }
        if (!startedEvent.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalArgumentException("First event is corrupted");
        }
    }

    public String toJson(boolean prettyPrint) {
        JsonFormat.Printer printer = JsonFormat.printer();
        try {
            String protoJson = printer.print((MessageOrBuilder)this.history);
            String historyFormatJson = HistoryJsonUtils.protoJsonToHistoryFormatJson(protoJson);
            if (prettyPrint) {
                JsonElement je = GSON_PARSER.parse(historyFormatJson);
                return GSON_PRETTY_PRINTER.toJson(je);
            }
            return historyFormatJson;
        }
        catch (InvalidProtocolBufferException e) {
            throw new DataConverterException(e);
        }
    }

    public String toProtoText(boolean showWorkflowTasks) {
        return HistoryProtoTextUtils.toProtoText(this.history, showWorkflowTasks);
    }

    public WorkflowExecution getWorkflowExecution() {
        return WorkflowExecution.newBuilder().setWorkflowId("workflow_id_in_replay").setRunId("run_id_in_replay").build();
    }

    public List<HistoryEvent> getEvents() {
        return this.history.getEventsList();
    }

    public HistoryEvent getLastEvent() {
        int eventsCount = this.history.getEventsCount();
        return eventsCount > 0 ? this.history.getEvents(eventsCount - 1) : null;
    }

    public History getHistory() {
        return this.history;
    }

    public String toString() {
        return "WorkflowExecutionHistory{history=" + this.history + '}';
    }
}

