/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.history;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.common.converter.StdConverterBackwardsCompatAdapter;
import java.util.Optional;

public class MarkerUtils {
    public static final String VERSION_MARKER_NAME = "Version";
    public static final String LOCAL_ACTIVITY_MARKER_NAME = "LocalActivity";

    public static boolean verifyMarkerName(HistoryEvent event, String markerName) {
        if (!EventType.EVENT_TYPE_MARKER_RECORDED.equals((Object)event.getEventType())) {
            return false;
        }
        MarkerRecordedEventAttributes attributes = event.getMarkerRecordedEventAttributes();
        return markerName.equals(attributes.getMarkerName());
    }

    public static <T> T getValueFromMarker(MarkerRecordedEventAttributes markerAttributes, String key, Class<T> simpleValueType) {
        Optional<Payloads> payloads = Optional.ofNullable((Payloads)markerAttributes.getDetailsMap().get(key));
        return StdConverterBackwardsCompatAdapter.fromPayloads(0, payloads, simpleValueType, simpleValueType);
    }
}

