/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.internal.common.ProtobufTimeUtils;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class BasicWorkflowContext {
    private final long runStartedTimestampMillis;
    private final WorkflowExecutionStartedEventAttributes startedAttributes;
    private final String namespace;
    @Nonnull
    private final WorkflowExecution workflowExecution;
    @Nullable
    private final Payloads lastCompletionResult;
    @Nullable
    private final Failure previousRunFailure;
    private SearchAttributes.Builder searchAttributes;
    private boolean cancelRequested;
    private ContinueAsNewWorkflowExecutionCommandAttributes continueAsNewOnCompletion;

    BasicWorkflowContext(String namespace, @Nonnull WorkflowExecution workflowExecution, WorkflowExecutionStartedEventAttributes startedAttributes, long runStartedTimestampMillis) {
        this.namespace = namespace;
        this.workflowExecution = (WorkflowExecution)Preconditions.checkNotNull((Object)workflowExecution);
        this.startedAttributes = startedAttributes;
        if (startedAttributes.hasSearchAttributes()) {
            this.searchAttributes = startedAttributes.getSearchAttributes().toBuilder();
        }
        this.runStartedTimestampMillis = runStartedTimestampMillis;
        this.lastCompletionResult = startedAttributes.hasLastCompletionResult() ? startedAttributes.getLastCompletionResult() : null;
        this.previousRunFailure = startedAttributes.hasContinuedFailure() ? startedAttributes.getContinuedFailure() : null;
    }

    @Nonnull
    WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    WorkflowType getWorkflowType() {
        return this.startedAttributes.getWorkflowType();
    }

    boolean isCancelRequested() {
        return this.cancelRequested;
    }

    void setCancelRequested(boolean flag) {
        this.cancelRequested = flag;
    }

    ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion() {
        return this.continueAsNewOnCompletion;
    }

    void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes parameters) {
        this.continueAsNewOnCompletion = parameters;
    }

    Optional<String> getContinuedExecutionRunId() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        String runId = attributes.getContinuedExecutionRunId();
        return runId.isEmpty() ? Optional.empty() : Optional.of(runId);
    }

    WorkflowExecution getParentWorkflowExecution() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.hasParentWorkflowExecution() ? attributes.getParentWorkflowExecution() : null;
    }

    Duration getWorkflowRunTimeout() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return ProtobufTimeUtils.toJavaDuration(attributes.getWorkflowRunTimeout());
    }

    Duration getWorkflowExecutionTimeout() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return ProtobufTimeUtils.toJavaDuration(attributes.getWorkflowExecutionTimeout());
    }

    long getWorkflowExecutionExpirationTimestampMillis() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return Timestamps.toMillis((Timestamp)attributes.getWorkflowExecutionExpirationTime());
    }

    long getRunStartedTimestampMillis() {
        return this.runStartedTimestampMillis;
    }

    Duration getWorkflowTaskTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.startedAttributes.getWorkflowTaskTimeout());
    }

    String getTaskQueue() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getTaskQueue().getName();
    }

    String getNamespace() {
        return this.namespace;
    }

    private WorkflowExecutionStartedEventAttributes getWorkflowStartedEventAttributes() {
        return this.startedAttributes;
    }

    public Map<String, Payload> getHeader() {
        return this.startedAttributes.getHeader().getFieldsMap();
    }

    public Payload getMemo(String key) {
        return (Payload)this.startedAttributes.getMemo().getFieldsMap().get(key);
    }

    @Nullable
    SearchAttributes getSearchAttributes() {
        return this.searchAttributes == null || this.searchAttributes.getIndexedFieldsCount() == 0 ? null : this.searchAttributes.build();
    }

    int getAttempt() {
        return this.startedAttributes.getAttempt();
    }

    void mergeSearchAttributes(SearchAttributes searchAttributes) {
        if (searchAttributes == null || searchAttributes.getIndexedFieldsCount() == 0) {
            return;
        }
        if (this.searchAttributes == null) {
            this.searchAttributes = SearchAttributes.newBuilder();
        }
        this.searchAttributes.putAllIndexedFields(searchAttributes.getIndexedFieldsMap());
    }

    public String getCronSchedule() {
        return this.startedAttributes.getCronSchedule();
    }

    @Nullable
    public Payloads getLastCompletionResult() {
        return this.lastCompletionResult;
    }

    @Nullable
    public Failure getPreviousRunFailure() {
        return this.previousRunFailure;
    }
}

