/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.FailWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.QueryResultType;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.ResetStickyTaskQueueRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.replay.QueryResult;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowFactory;
import io.temporal.internal.replay.ReplayWorkflowRunTaskHandler;
import io.temporal.internal.replay.ServiceWorkflowHistoryIterator;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.replay.WorkflowRunTaskHandler;
import io.temporal.internal.replay.WorkflowTaskResult;
import io.temporal.internal.worker.LocalActivityTask;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.internal.worker.WorkflowTaskHandler;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.NonDeterministicException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplayWorkflowTaskHandler
implements WorkflowTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(ReplayWorkflowTaskHandler.class);
    private final ReplayWorkflowFactory workflowFactory;
    private final String namespace;
    private final WorkflowExecutorCache cache;
    private final SingleWorkerOptions options;
    private final Duration stickyTaskQueueScheduleToStartTimeout;
    private final WorkflowServiceStubs service;
    private final String stickyTaskQueueName;
    private final BiFunction<LocalActivityTask, Duration, Boolean> localActivityTaskPoller;

    public ReplayWorkflowTaskHandler(String namespace, ReplayWorkflowFactory asyncWorkflowFactory, WorkflowExecutorCache cache, SingleWorkerOptions options, String stickyTaskQueueName, Duration stickyTaskQueueScheduleToStartTimeout, WorkflowServiceStubs service, BiFunction<LocalActivityTask, Duration, Boolean> localActivityTaskPoller) {
        this.namespace = namespace;
        this.workflowFactory = asyncWorkflowFactory;
        this.cache = cache;
        this.options = options;
        this.stickyTaskQueueName = stickyTaskQueueName;
        this.stickyTaskQueueScheduleToStartTimeout = stickyTaskQueueScheduleToStartTimeout;
        this.service = Objects.requireNonNull(service);
        this.localActivityTaskPoller = localActivityTaskPoller;
    }

    @Override
    public WorkflowTaskHandler.Result handleWorkflowTask(PollWorkflowTaskQueueResponse workflowTask) throws Exception {
        String workflowType = workflowTask.getWorkflowType().getName();
        Scope metricsScope = this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"workflow_type", (Object)workflowType));
        return this.handleWorkflowTaskWithQuery(workflowTask.toBuilder(), metricsScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowTaskHandler.Result handleWorkflowTaskWithQuery(PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope) throws Exception {
        boolean directQuery = workflowTask.hasQuery();
        AtomicBoolean createdNew = new AtomicBoolean();
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        WorkflowRunTaskHandler workflowRunTaskHandler = null;
        boolean useCache = this.stickyTaskQueueName != null;
        try {
            WorkflowTaskHandler.Result result;
            boolean finalCommand;
            workflowRunTaskHandler = this.getOrCreateWorkflowExecutor(useCache, workflowTask, metricsScope, createdNew);
            this.logWorkflowTaskToBeProcessed(workflowTask, createdNew);
            ServiceWorkflowHistoryIterator historyIterator = new ServiceWorkflowHistoryIterator(this.service, this.namespace, (PollWorkflowTaskQueueResponseOrBuilder)workflowTask, metricsScope);
            if (directQuery) {
                QueryResult queryResult = workflowRunTaskHandler.handleDirectQueryWorkflowTask((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, historyIterator);
                finalCommand = queryResult.isWorkflowMethodCompleted();
                result = this.createDirectQueryResult((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, queryResult, null);
            } else {
                WorkflowTaskResult wftResult = workflowRunTaskHandler.handleWorkflowTask((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, historyIterator);
                finalCommand = wftResult.isFinalCommand();
                result = this.createCompletedWFTRequest(workflowTask.getWorkflowType().getName(), (PollWorkflowTaskQueueResponseOrBuilder)workflowTask, wftResult);
            }
            if (useCache) {
                if (finalCommand) {
                    this.cache.invalidate(execution, metricsScope, "FinalCommand", null);
                } else if (createdNew.get()) {
                    this.cache.addToCache(execution, workflowRunTaskHandler);
                }
            }
            WorkflowTaskHandler.Result result2 = result;
            return result2;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            if (workflowRunTaskHandler != null) {
                workflowRunTaskHandler.close();
            }
            if (useCache) {
                this.cache.invalidate(execution, metricsScope, "Exception", e);
                if (!WorkflowExecutionUtils.isFullHistory((PollWorkflowTaskQueueResponseOrBuilder)workflowTask)) {
                    this.resetStickyTaskQueue(execution);
                }
            }
            if (directQuery) {
                WorkflowTaskHandler.Result result = this.createDirectQueryResult((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, null, e);
                return result;
            }
            WorkflowTaskHandler.Result result = this.failureToWFTResult((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, e);
            return result;
        }
        finally {
            if (useCache) {
                this.cache.markProcessingDone(execution);
            } else if (workflowRunTaskHandler != null) {
                workflowRunTaskHandler.close();
            }
        }
    }

    private WorkflowTaskHandler.Result createCompletedWFTRequest(String workflowType, PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowTaskResult result) {
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        if (log.isTraceEnabled()) {
            log.trace("WorkflowTask startedEventId=" + workflowTask.getStartedEventId() + ", WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + " completed with \n" + WorkflowExecutionUtils.prettyPrintCommands(result.getCommands()));
        } else if (log.isDebugEnabled()) {
            log.debug("WorkflowTask startedEventId=" + workflowTask.getStartedEventId() + ", WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + " completed with " + result.getCommands().size() + " new commands");
        }
        RespondWorkflowTaskCompletedRequest.Builder completedRequest = RespondWorkflowTaskCompletedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).addAllCommands(result.getCommands()).putAllQueryResults(result.getQueryResults()).setForceCreateNewWorkflowTask(result.isForceWorkflowTask()).setReturnNewWorkflowTask(result.isForceWorkflowTask());
        if (!(this.stickyTaskQueueName == null || this.stickyTaskQueueScheduleToStartTimeout != null && this.stickyTaskQueueScheduleToStartTimeout.isZero())) {
            StickyExecutionAttributes.Builder attributes = StickyExecutionAttributes.newBuilder().setWorkerTaskQueue(InternalUtils.createStickyTaskQueue(this.stickyTaskQueueName));
            if (this.stickyTaskQueueScheduleToStartTimeout != null) {
                attributes.setScheduleToStartTimeout(ProtobufTimeUtils.toProtoDuration(this.stickyTaskQueueScheduleToStartTimeout));
            }
            completedRequest.setStickyAttributes(attributes);
        }
        return new WorkflowTaskHandler.Result(workflowType, completedRequest.build(), null, null, null, result.isFinalCommand());
    }

    private WorkflowTaskHandler.Result failureToWFTResult(PollWorkflowTaskQueueResponseOrBuilder workflowTask, Throwable e) throws Exception {
        String workflowType = workflowTask.getWorkflowType().getName();
        if (e instanceof WorkflowExecutionException) {
            RespondWorkflowTaskCompletedRequest response = RespondWorkflowTaskCompletedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).setIdentity(this.options.getIdentity()).setNamespace(this.namespace).setBinaryChecksum(this.options.getBinaryChecksum()).addCommands(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION).setFailWorkflowExecutionCommandAttributes(FailWorkflowExecutionCommandAttributes.newBuilder().setFailure(((WorkflowExecutionException)e).getFailure())).build()).build();
            return new WorkflowTaskHandler.Result(workflowType, response, null, null, null, false);
        }
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        log.warn("Workflow task processing failure. startedEventId={}, WorkflowId={}, RunId={}. If seen continuously the workflow might be stuck.", new Object[]{workflowTask.getStartedEventId(), execution.getWorkflowId(), execution.getRunId(), e});
        if (workflowTask.getAttempt() > 1) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (Exception)e;
        }
        Failure failure = FailureConverter.exceptionToFailure(e);
        RespondWorkflowTaskFailedRequest.Builder failedRequest = RespondWorkflowTaskFailedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).setFailure(failure);
        if (e instanceof NonDeterministicException) {
            failedRequest.setCause(WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_NON_DETERMINISTIC_ERROR);
        }
        return new WorkflowTaskHandler.Result(workflowType, null, failedRequest.build(), null, null, false);
    }

    private WorkflowTaskHandler.Result createDirectQueryResult(PollWorkflowTaskQueueResponseOrBuilder workflowTask, QueryResult queryResult, Throwable e) {
        RespondQueryTaskCompletedRequest.Builder queryCompletedRequest = RespondQueryTaskCompletedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).setNamespace(this.namespace);
        if (e == null) {
            queryCompletedRequest.setCompletedType(QueryResultType.QUERY_RESULT_TYPE_ANSWERED);
            queryResult.getResponsePayloads().ifPresent(arg_0 -> ((RespondQueryTaskCompletedRequest.Builder)queryCompletedRequest).setQueryResult(arg_0));
        } else {
            queryCompletedRequest.setCompletedType(QueryResultType.QUERY_RESULT_TYPE_FAILED);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            queryCompletedRequest.setErrorMessage(sw.toString());
        }
        return new WorkflowTaskHandler.Result(workflowTask.getWorkflowType().getName(), null, null, queryCompletedRequest.build(), null, false);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return this.workflowFactory.isAnyTypeSupported();
    }

    private WorkflowRunTaskHandler getOrCreateWorkflowExecutor(boolean useCache, PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope, AtomicBoolean createdNew) throws Exception {
        if (useCache) {
            return this.cache.getOrCreate((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, metricsScope, () -> {
                createdNew.set(true);
                return this.createStatefulHandler(workflowTask, metricsScope);
            });
        }
        createdNew.set(true);
        return this.createStatefulHandler(workflowTask, metricsScope);
    }

    private WorkflowRunTaskHandler createStatefulHandler(PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope) throws Exception {
        WorkflowType workflowType = workflowTask.getWorkflowType();
        List events = workflowTask.getHistory().getEventsList();
        if (events.isEmpty() || ((HistoryEvent)events.get(0)).getEventId() > 1L) {
            GetWorkflowExecutionHistoryRequest getHistoryRequest = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.namespace).setExecution(workflowTask.getWorkflowExecution()).build();
            GetWorkflowExecutionHistoryResponse getHistoryResponse = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).getWorkflowExecutionHistory(getHistoryRequest);
            workflowTask.setHistory(getHistoryResponse.getHistory()).setNextPageToken(getHistoryResponse.getNextPageToken());
        }
        ReplayWorkflow workflow = this.workflowFactory.getWorkflow(workflowType);
        return new ReplayWorkflowRunTaskHandler(this.namespace, workflow, (PollWorkflowTaskQueueResponseOrBuilder)workflowTask, this.options, metricsScope, this.localActivityTaskPoller);
    }

    private void resetStickyTaskQueue(WorkflowExecution execution) {
        ((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).resetStickyTaskQueue(ResetStickyTaskQueueRequest.newBuilder().setNamespace(this.namespace).setExecution(execution).build());
    }

    private void logWorkflowTaskToBeProcessed(PollWorkflowTaskQueueResponse.Builder workflowTask, AtomicBoolean createdNew) {
        if (log.isDebugEnabled()) {
            boolean directQuery = workflowTask.hasQuery();
            WorkflowExecution execution = workflowTask.getWorkflowExecution();
            if (directQuery) {
                log.debug("Handle Direct Query {}. WorkflowId='{}', RunId='{}', queryType='{}', startedEventId={}, previousStartedEventId={}", new Object[]{createdNew.get() ? "with new executor" : "with existing executor", execution.getWorkflowId(), execution.getRunId(), workflowTask.getQuery().getQueryType(), workflowTask.getStartedEventId(), workflowTask.getPreviousStartedEventId()});
            } else {
                log.debug("Handle Workflow Task {}. {}WorkflowId='{}', RunId='{}', startedEventId='{}', previousStartedEventId:{}", new Object[]{createdNew.get() ? "with new executor" : "with existing executor", workflowTask.getQueriesMap().isEmpty() ? "" : "With queries: " + workflowTask.getQueriesMap().values().stream().map(WorkflowQuery::getQueryType).collect(Collectors.toList()) + ". ", execution.getWorkflowId(), execution.getRunId(), workflowTask.getStartedEventId(), workflowTask.getPreviousStartedEventId()});
            }
        }
    }
}

