/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.ShutdownableTaskExecutor;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PollWorkflowTaskDispatcher
implements ShutdownableTaskExecutor<PollWorkflowTaskQueueResponse> {
    private static final Logger log = LoggerFactory.getLogger(PollWorkflowTaskDispatcher.class);
    private final Map<String, Functions.Proc1<PollWorkflowTaskQueueResponse>> subscribers = new ConcurrentHashMap<String, Functions.Proc1<PollWorkflowTaskQueueResponse>>();
    private final String namespace;
    private final Scope metricsScope;
    private final WorkflowServiceStubs service;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (t, e) -> log.error("uncaught exception", e);
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public PollWorkflowTaskDispatcher(WorkflowServiceStubs service, String namespace, Scope metricsScope) {
        this.service = Objects.requireNonNull(service);
        this.namespace = namespace;
        this.metricsScope = Objects.requireNonNull(metricsScope);
    }

    @Override
    public void process(PollWorkflowTaskQueueResponse task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("shutdown");
        }
        String taskQueueName = task.getWorkflowExecutionTaskQueue().getName();
        if (this.subscribers.containsKey(taskQueueName)) {
            this.subscribers.get(taskQueueName).apply(task);
        } else {
            Exception exception = new Exception(String.format("No handler is subscribed for the PollWorkflowTaskQueueResponse.WorkflowExecutionTaskQueue %s", taskQueueName));
            RespondWorkflowTaskFailedRequest request = RespondWorkflowTaskFailedRequest.newBuilder().setNamespace(this.namespace).setTaskToken(task.getTaskToken()).setCause(WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_RESET_STICKY_TASK_QUEUE).setFailure(FailureConverter.exceptionToFailure(exception)).build();
            log.warn("unexpected", (Throwable)exception);
            try {
                ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondWorkflowTaskFailed(request);
            }
            catch (Exception e) {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
        }
    }

    public void subscribe(String taskQueue, Functions.Proc1<PollWorkflowTaskQueueResponse> consumer) {
        this.subscribers.put(taskQueue, consumer);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown.get();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        this.shutdown.set(true);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
    }
}

