/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.internal.worker.PollWorkflowTaskDispatcher;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.internal.worker.WorkflowPollTask;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class StickyPoller
implements SuspendableWorker {
    private final Poller<PollWorkflowTaskQueueResponse> poller;
    private final PollWorkflowTaskDispatcher dispatcher;

    public StickyPoller(WorkflowServiceStubs workflowServiceStubs, String stickyTaskQueueName, int pollThreadCount, WorkflowClientOptions workflowClientOptions, Scope metricsScope) {
        String namespace = workflowClientOptions.getNamespace();
        Scope stickyScope = metricsScope.tagged((Map)new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)"sticky").build());
        this.dispatcher = new PollWorkflowTaskDispatcher(workflowServiceStubs, namespace, metricsScope);
        this.poller = new Poller<PollWorkflowTaskQueueResponse>(workflowClientOptions.getIdentity(), new WorkflowPollTask(workflowServiceStubs, namespace, stickyTaskQueueName, workflowClientOptions.getIdentity(), workflowClientOptions.getBinaryChecksum(), stickyScope), this.dispatcher, PollerOptions.newBuilder().setPollThreadNamePrefix(WorkerThreadsNameHelper.getStickyQueueWorkflowPollerThreadPrefix(namespace, stickyTaskQueueName)).setPollThreadCount(pollThreadCount).build(), stickyScope);
    }

    public void subscribe(String taskQueue, Functions.Proc1<PollWorkflowTaskQueueResponse> consumer) {
        this.dispatcher.subscribe(taskQueue, consumer);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    @Override
    public void start() {
        this.poller.start();
    }

    @Override
    public boolean isStarted() {
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return this.poller.shutdown(shutdownManager, interruptTasks);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.poller.awaitTermination(timeout, unit);
    }
}

