/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.Poller;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowPollTask
implements Poller.PollTask<PollWorkflowTaskQueueResponse> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPollTask.class);
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final String identity;
    private final String binaryChecksum;
    private final Scope metricsScope;

    public WorkflowPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, @Nullable String binaryChecksum, @Nonnull Scope metricsScope) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.identity = Objects.requireNonNull(identity);
        this.binaryChecksum = binaryChecksum;
        this.metricsScope = Objects.requireNonNull(metricsScope);
    }

    @Override
    public PollWorkflowTaskQueueResponse poll() {
        PollWorkflowTaskQueueRequest pollRequest = PollWorkflowTaskQueueRequest.newBuilder().setNamespace(this.namespace).setBinaryChecksum(this.binaryChecksum).setIdentity(this.identity).setTaskQueue(TaskQueue.newBuilder().setName(this.taskQueue).build()).build();
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + pollRequest);
        }
        PollWorkflowTaskQueueResponse result = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollWorkflowTaskQueue(pollRequest);
        if (log.isTraceEnabled()) {
            log.trace("poll request returned workflow task: workflowType=" + result.getWorkflowType() + ", workflowExecution=" + result.getWorkflowExecution() + ", startedEventId=" + result.getStartedEventId() + ", previousStartedEventId=" + result.getPreviousStartedEventId() + (result.getQuery() != null ? ", queryType=" + result.getQuery().getQueryType() : ""));
        }
        if (result == null || result.getTaskToken().isEmpty()) {
            this.metricsScope.counter("temporal_workflow_task_queue_poll_empty").inc(1L);
            return null;
        }
        this.metricsScope.counter("temporal_workflow_task_queue_poll_succeed").inc(1L);
        this.metricsScope.timer("temporal_workflow_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(result.getStartedTime(), result.getScheduledTime()));
        return result;
    }
}

