/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.worker.NoopSuspendableWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.UnableToAcquireLockException;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.internal.worker.WorkflowPollTask;
import io.temporal.internal.worker.WorkflowRunLockManager;
import io.temporal.internal.worker.WorkflowTaskHandler;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkerMetricsTag;
import io.temporal.workflow.Functions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class WorkflowWorker
implements SuspendableWorker,
Functions.Proc1<PollWorkflowTaskQueueResponse> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowWorker.class);
    private final WorkflowRunLockManager runLocks = new WorkflowRunLockManager();
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final WorkflowExecutorCache cache;
    private final WorkflowTaskHandler handler;
    private final String stickyTaskQueueName;
    private final PollerOptions pollerOptions;
    private final Scope workerMetricsScope;
    private final GrpcRetryer grpcRetryer;
    @Nonnull
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private PollTaskExecutor<PollWorkflowTaskQueueResponse> pollTaskExecutor;

    public WorkflowWorker(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nullable String stickyTaskQueueName, @Nonnull SingleWorkerOptions options, @Nonnull WorkflowExecutorCache cache, @Nonnull WorkflowTaskHandler handler) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.options = Objects.requireNonNull(options);
        this.stickyTaskQueueName = stickyTaskQueueName;
        this.pollerOptions = this.getPollerOptions(options);
        this.workerMetricsScope = MetricsTag.tagged((Scope)options.getMetricsScope(), (MetricsTag.TagValue)WorkerMetricsTag.WorkerType.WORKFLOW_WORKER);
        this.cache = Objects.requireNonNull(cache);
        this.handler = Objects.requireNonNull(handler);
        this.grpcRetryer = new GrpcRetryer(service.getServerCapabilities());
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.pollTaskExecutor = new PollTaskExecutor<PollWorkflowTaskQueueResponse>(this.namespace, this.taskQueue, this.options.getIdentity(), new TaskHandlerImpl(this.handler), this.pollerOptions, this.options.getTaskExecutorThreadPoolSize(), this.workerMetricsScope);
            this.poller = new Poller<PollWorkflowTaskQueueResponse>(this.options.getIdentity(), new WorkflowPollTask(this.service, this.namespace, this.taskQueue, this.options.getIdentity(), this.options.getBinaryChecksum(), this.workerMetricsScope), this.pollTaskExecutor, this.pollerOptions, this.workerMetricsScope);
            this.poller.start();
            this.workerMetricsScope.counter("temporal_worker_start").inc(1L);
        }
    }

    @Override
    public boolean isStarted() {
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return this.poller.shutdown(shutdownManager, interruptTasks);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    @Override
    public void apply(PollWorkflowTaskQueueResponse pollWorkflowTaskQueueResponse) {
        this.pollTaskExecutor.process(pollWorkflowTaskQueueResponse);
    }

    private PollerOptions getPollerOptions(SingleWorkerOptions options) {
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix(WorkerThreadsNameHelper.getWorkflowPollerThreadPrefix(this.namespace, this.taskQueue)).build();
        }
        return pollerOptions;
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<PollWorkflowTaskQueueResponse> {
        final WorkflowTaskHandler handler;

        private TaskHandlerImpl(WorkflowTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PollWorkflowTaskQueueResponse task) throws Exception {
            WorkflowExecution workflowExecution = task.getWorkflowExecution();
            String runId = workflowExecution.getRunId();
            String workflowType = task.getWorkflowType().getName();
            Scope workflowTypeScope = WorkflowWorker.this.workerMetricsScope.tagged((Map)ImmutableMap.of((Object)"workflow_type", (Object)workflowType));
            MDC.put((String)"WorkflowId", (String)workflowExecution.getWorkflowId());
            MDC.put((String)"WorkflowType", (String)workflowType);
            MDC.put((String)"RunId", (String)runId);
            boolean locked = false;
            if (!Strings.isNullOrEmpty((String)WorkflowWorker.this.stickyTaskQueueName) && !(locked = WorkflowWorker.this.runLocks.tryLock(runId, 1L, TimeUnit.SECONDS))) {
                throw new UnableToAcquireLockException("Workflow lock for the run id hasn't been released by one of previous execution attempts, consider increasing workflow task timeout.");
            }
            Stopwatch swTotal = workflowTypeScope.timer("temporal_workflow_task_execution_total_latency").start();
            try {
                Optional<PollWorkflowTaskQueueResponse> nextTask = Optional.of(task);
                do {
                    PollWorkflowTaskQueueResponse currentTask = nextTask.get();
                    WorkflowTaskHandler.Result response = this.handleTask(currentTask, workflowTypeScope);
                    try {
                        nextTask = this.sendReply(currentTask.getTaskToken(), WorkflowWorker.this.service, workflowTypeScope, response);
                    }
                    catch (Exception e) {
                        this.logExceptionDuringResultReporting(e, currentTask, response);
                        workflowTypeScope.counter("temporal_workflow_task_execution_failed").inc(1L);
                        WorkflowWorker.this.cache.invalidate(workflowExecution, workflowTypeScope, "Failed result reporting to the server", e);
                        throw e;
                    }
                    if (response.getTaskFailed() != null) {
                        workflowTypeScope.counter("temporal_workflow_task_execution_failed").inc(1L);
                    }
                    if (!nextTask.isPresent()) continue;
                    workflowTypeScope.counter("temporal_workflow_task_heartbeat").inc(1L);
                } while (nextTask.isPresent());
            }
            finally {
                swTotal.stop();
                MDC.remove((String)"WorkflowId");
                MDC.remove((String)"WorkflowType");
                MDC.remove((String)"RunId");
                if (locked) {
                    WorkflowWorker.this.runLocks.unlock(runId);
                }
            }
        }

        @Override
        public Throwable wrapFailure(PollWorkflowTaskQueueResponse task, Throwable failure) {
            WorkflowExecution execution = task.getWorkflowExecution();
            return new RuntimeException("Failure processing workflow task. WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + ", Attempt=" + task.getAttempt(), failure);
        }

        private WorkflowTaskHandler.Result handleTask(PollWorkflowTaskQueueResponse task, Scope workflowTypeMetricsScope) throws Exception {
            Stopwatch sw = workflowTypeMetricsScope.timer("temporal_workflow_task_execution_latency").start();
            try {
                WorkflowTaskHandler.Result result = this.handler.handleWorkflowTask(task);
                return result;
            }
            catch (Throwable e) {
                workflowTypeMetricsScope.counter("temporal_workflow_task_execution_failed").inc(1L);
                workflowTypeMetricsScope.counter("temporal_workflow_task_no_completion").inc(1L);
                throw e;
            }
            finally {
                sw.stop();
            }
        }

        private Optional<PollWorkflowTaskQueueResponse> sendReply(ByteString taskToken, WorkflowServiceStubs service, Scope workflowTypeMetricsScope, WorkflowTaskHandler.Result response) {
            RpcRetryOptions retryOptions = response.getRequestRetryOptions();
            RespondWorkflowTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                GrpcRetryer.GrpcRetryerOptions grpcRetryOptions = new GrpcRetryer.GrpcRetryerOptions(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(retryOptions), null);
                RespondWorkflowTaskCompletedRequest request = taskCompleted.toBuilder().setIdentity(WorkflowWorker.this.options.getIdentity()).setNamespace(WorkflowWorker.this.namespace).setBinaryChecksum(WorkflowWorker.this.options.getBinaryChecksum()).setTaskToken(taskToken).build();
                AtomicReference nextTask = new AtomicReference();
                WorkflowWorker.this.grpcRetryer.retry(() -> nextTask.set(((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)workflowTypeMetricsScope)).respondWorkflowTaskCompleted(request)), grpcRetryOptions);
                if (((RespondWorkflowTaskCompletedResponse)nextTask.get()).hasWorkflowTask()) {
                    return Optional.of(((RespondWorkflowTaskCompletedResponse)nextTask.get()).getWorkflowTask());
                }
            } else {
                RespondWorkflowTaskFailedRequest taskFailed = response.getTaskFailed();
                if (taskFailed != null) {
                    GrpcRetryer.GrpcRetryerOptions grpcRetryOptions = new GrpcRetryer.GrpcRetryerOptions(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(retryOptions), null);
                    RespondWorkflowTaskFailedRequest request = taskFailed.toBuilder().setIdentity(WorkflowWorker.this.options.getIdentity()).setNamespace(WorkflowWorker.this.namespace).setTaskToken(taskToken).build();
                    WorkflowWorker.this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)workflowTypeMetricsScope)).respondWorkflowTaskFailed(request), grpcRetryOptions);
                } else {
                    RespondQueryTaskCompletedRequest queryCompleted = response.getQueryCompleted();
                    if (queryCompleted != null) {
                        queryCompleted = queryCompleted.toBuilder().setTaskToken(taskToken).setNamespace(WorkflowWorker.this.namespace).build();
                        ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)workflowTypeMetricsScope)).respondQueryTaskCompleted(queryCompleted);
                    }
                }
            }
            return Optional.empty();
        }

        private void logExceptionDuringResultReporting(Exception e, PollWorkflowTaskQueueResponse currentTask, WorkflowTaskHandler.Result result) {
            if (log.isDebugEnabled()) {
                log.debug("Failure during reporting of workflow progress to the server. If seen continuously the workflow might be stuck. WorkflowId={}, RunId={}, startedEventId={}, WFTResult={}", new Object[]{currentTask.getWorkflowExecution().getWorkflowId(), currentTask.getWorkflowExecution().getRunId(), currentTask.getStartedEventId(), result, e});
            } else {
                log.warn("Failure while reporting workflow progress to the server. If seen continuously the workflow might be stuck. WorkflowId={}, RunId={}, startedEventId={}", new Object[]{currentTask.getWorkflowExecution().getWorkflowId(), currentTask.getWorkflowExecution().getRunId(), currentTask.getStartedEventId(), e});
            }
        }
    }
}

