/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SyncActivityWorker;
import io.temporal.internal.worker.SyncWorkflowWorker;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public final class Worker {
    private final WorkerOptions options;
    private final String taskQueue;
    final SyncWorkflowWorker workflowWorker;
    final SyncActivityWorker activityWorker;
    private final AtomicBoolean started = new AtomicBoolean();
    private final Scope metricsScope;

    Worker(WorkflowClient client, String taskQueue, WorkerFactoryOptions factoryOptions, WorkerOptions options, Scope metricsScope, @Nonnull WorkflowExecutorCache cache, String stickyTaskQueueName, WorkflowThreadExecutor workflowThreadExecutor, List<ContextPropagator> contextPropagators) {
        Objects.requireNonNull(client, "client should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskQueue) ? 1 : 0) != 0, (Object)"taskQueue should not be an empty string");
        this.taskQueue = taskQueue;
        this.options = WorkerOptions.newBuilder(options).validateAndBuildWithDefaults();
        factoryOptions = WorkerFactoryOptions.newBuilder(factoryOptions).validateAndBuildWithDefaults();
        WorkflowServiceStubs service = client.getWorkflowServiceStubs();
        WorkflowClientOptions clientOptions = client.getOptions();
        String namespace = clientOptions.getNamespace();
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)taskQueue).build();
        this.metricsScope = metricsScope.tagged((Map)tags);
        SingleWorkerOptions activityOptions = Worker.toActivityOptions(factoryOptions, this.options, clientOptions, contextPropagators, this.metricsScope);
        this.activityWorker = this.options.isLocalActivityWorkerOnly() ? null : new SyncActivityWorker(service, namespace, taskQueue, this.options.getMaxTaskQueueActivitiesPerSecond(), activityOptions);
        SingleWorkerOptions singleWorkerOptions = Worker.toWorkflowWorkerOptions(factoryOptions, this.options, clientOptions, taskQueue, contextPropagators, this.metricsScope);
        SingleWorkerOptions localActivityOptions = Worker.toLocalActivityOptions(factoryOptions, this.options, clientOptions, contextPropagators, this.metricsScope);
        this.workflowWorker = new SyncWorkflowWorker(service, namespace, taskQueue, singleWorkerOptions, localActivityOptions, cache, stickyTaskQueueName, factoryOptions.getWorkflowHostLocalTaskQueueScheduleToStartTimeout(), workflowThreadExecutor);
    }

    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.registerWorkflowImplementationTypes(WorkflowImplementationOptions.newBuilder().build(), workflowImplementationClasses);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.registerWorkflowImplementationTypes(options, workflowImplementationClasses);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.addWorkflowImplementationFactory(options, workflowInterface, factory);
    }

    @VisibleForTesting
    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.addWorkflowImplementationFactory(workflowInterface, factory);
    }

    public void registerActivitiesImplementations(Object ... activityImplementations) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerActivitiesImplementations is not allowed after worker has started");
        if (this.activityWorker != null) {
            this.activityWorker.registerActivityImplementations(activityImplementations);
        }
        this.workflowWorker.registerLocalActivityImplementations(activityImplementations);
    }

    void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.workflowWorker.start();
        if (this.activityWorker != null) {
            this.activityWorker.start();
        }
    }

    CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptUserTasks) {
        CompletableFuture<Void> workflowWorkerShutdownFuture = this.workflowWorker.shutdown(shutdownManager, interruptUserTasks);
        if (this.activityWorker != null) {
            return CompletableFuture.allOf(this.activityWorker.shutdown(shutdownManager, interruptUserTasks), workflowWorkerShutdownFuture);
        }
        return workflowWorkerShutdownFuture;
    }

    boolean isTerminated() {
        boolean isTerminated = this.workflowWorker.isTerminated();
        if (this.activityWorker != null) {
            isTerminated = this.activityWorker.isTerminated();
        }
        return isTerminated;
    }

    void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = unit.toMillis(timeout);
        if (this.activityWorker != null) {
            timeoutMillis = ShutdownManager.awaitTermination(this.activityWorker, timeoutMillis);
        }
        ShutdownManager.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    public String toString() {
        return "Worker{options=" + this.options + '}';
    }

    @VisibleForTesting
    public void replayWorkflowExecution(WorkflowExecutionHistory history) throws Exception {
        this.workflowWorker.queryWorkflowExecution(history, "__replay_only", String.class, (Type)((Object)String.class), new Object[0]);
    }

    public void replayWorkflowExecution(String jsonSerializedHistory) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        this.replayWorkflowExecution(history);
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
        if (this.activityWorker != null) {
            this.activityWorker.suspendPolling();
        }
    }

    public void resumePolling() {
        this.workflowWorker.resumePolling();
        if (this.activityWorker != null) {
            this.activityWorker.resumePolling();
        }
    }

    public boolean isSuspended() {
        return this.workflowWorker.isSuspended() && (this.activityWorker == null || this.activityWorker.isSuspended());
    }

    public static String getWorkflowType(Class<?> workflowInterfaceClass) {
        return WorkflowInternal.getWorkflowType(workflowInterfaceClass);
    }

    private static SingleWorkerOptions toActivityOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setPollerOptions(PollerOptions.newBuilder().setMaximumPollRatePerSecond(options.getMaxWorkerActivitiesPerSecond()).setPollThreadCount(options.getMaxConcurrentActivityTaskPollers()).build()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentActivityExecutionSize()).setMetricsScope(metricsScope).build();
    }

    private static SingleWorkerOptions toWorkflowWorkerOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, String taskQueue, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)taskQueue).build();
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setPollerOptions(PollerOptions.newBuilder().setPollThreadCount(options.getMaxConcurrentWorkflowTaskPollers()).build()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentWorkflowTaskExecutionSize()).setDefaultDeadlockDetectionTimeout(options.getDefaultDeadlockDetectionTimeout()).setMetricsScope(metricsScope.tagged((Map)tags)).build();
    }

    private static SingleWorkerOptions toLocalActivityOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setPollerOptions(PollerOptions.newBuilder().setPollThreadCount(1).build()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentLocalActivityExecutionSize()).setMetricsScope(metricsScope).build();
    }

    private static SingleWorkerOptions.Builder toSingleWorkerOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators) {
        return SingleWorkerOptions.newBuilder().setDataConverter(clientOptions.getDataConverter()).setIdentity(clientOptions.getIdentity()).setBinaryChecksum(clientOptions.getBinaryChecksum()).setEnableLoggingInReplay(factoryOptions.isEnableLoggingInReplay()).setContextPropagators(contextPropagators).setWorkerInterceptors(factoryOptions.getWorkerInterceptors()).setMaxHeartbeatThrottleInterval(options.getMaxHeartbeatThrottleInterval()).setDefaultHeartbeatThrottleInterval(options.getDefaultHeartbeatThrottleInterval());
    }
}

