/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.uber.m3.tally.Scope;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.StickyPoller;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkerFactory {
    private static final Logger log = LoggerFactory.getLogger(WorkerFactory.class);
    private final Scope metricsScope;
    private final Map<String, Worker> workers = new HashMap<String, Worker>();
    private final WorkflowClient workflowClient;
    private final UUID id = UUID.randomUUID();
    private final ThreadPoolExecutor workflowThreadPool;
    private final WorkflowThreadExecutor workflowThreadExecutor;
    private final AtomicInteger workflowThreadCounter = new AtomicInteger();
    private final WorkerFactoryOptions factoryOptions;
    private final StickyPoller stickyPoller;
    @Nonnull
    private final WorkflowExecutorCache cache;
    private State state = State.Initial;
    private final String statusErrorMessage = "attempted to %s while in %s state. Acceptable States: %s";

    public static WorkerFactory newInstance(WorkflowClient workflowClient) {
        return WorkerFactory.newInstance(workflowClient, WorkerFactoryOptions.getDefaultInstance());
    }

    public static WorkerFactory newInstance(WorkflowClient workflowClient, WorkerFactoryOptions options) {
        return new WorkerFactory(workflowClient, options);
    }

    private WorkerFactory(WorkflowClient workflowClient, WorkerFactoryOptions factoryOptions) {
        this.workflowClient = Objects.requireNonNull(workflowClient);
        WorkflowClientOptions workflowClientOptions = workflowClient.getOptions();
        String namespace = workflowClientOptions.getNamespace();
        this.factoryOptions = WorkerFactoryOptions.newBuilder(factoryOptions).validateAndBuildWithDefaults();
        this.metricsScope = this.workflowClient.getWorkflowServiceStubs().getOptions().getMetricsScope().tagged(MetricsTag.defaultTags((String)namespace));
        this.workflowThreadPool = new ThreadPoolExecutor(0, this.factoryOptions.getMaxWorkflowThreadCount(), 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.workflowThreadPool.setThreadFactory(r -> new Thread(r, "workflow-thread-" + this.workflowThreadCounter.incrementAndGet()));
        this.workflowThreadExecutor = WorkerFactory.newWorkflowThreadExecutor(this.workflowThreadPool, this.metricsScope);
        this.cache = new WorkflowExecutorCache(this.factoryOptions.getWorkflowCacheSize(), this.metricsScope);
        this.stickyPoller = new StickyPoller(workflowClient.getWorkflowServiceStubs(), this.getStickyTaskQueueName(), this.factoryOptions.getWorkflowHostLocalPollThreadCount(), workflowClientOptions, this.metricsScope);
    }

    public Worker newWorker(String taskQueue) {
        return this.newWorker(taskQueue, null);
    }

    public synchronized Worker newWorker(String taskQueue, WorkerOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskQueue) ? 1 : 0) != 0, (Object)"taskQueue should not be an empty string");
        Preconditions.checkState((this.state == State.Initial ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "create new worker", this.state.name(), State.Initial.name()));
        Worker existingWorker = this.workers.get(taskQueue);
        if (existingWorker == null) {
            Worker worker = new Worker(this.workflowClient, taskQueue, this.factoryOptions, options, this.metricsScope, this.cache, this.getStickyTaskQueueName(), this.workflowThreadExecutor, this.workflowClient.getOptions().getContextPropagators());
            this.workers.put(taskQueue, worker);
            return worker;
        }
        log.warn("Only one worker can be registered for a task queue, subsequent calls to WorkerFactory#newWorker with the same task queue are ignored and initially created worker is returned");
        return existingWorker;
    }

    public synchronized Worker getWorker(String taskQueue) {
        Worker result = this.workers.get(taskQueue);
        if (result == null) {
            throw new IllegalArgumentException("No worker for taskQueue: " + taskQueue);
        }
        return result;
    }

    public synchronized Worker tryGetWorker(String taskQueue) {
        return this.workers.get(taskQueue);
    }

    public synchronized void start() {
        Preconditions.checkState((this.state == State.Initial || this.state == State.Started ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "start WorkerFactory", this.state.name(), String.format("%s, %s", State.Initial.name(), State.Initial.name())));
        if (this.state == State.Started) {
            return;
        }
        this.workflowClient.getWorkflowServiceStubs().connect(null);
        for (Worker worker : this.workers.values()) {
            worker.start();
            if (!worker.workflowWorker.isStarted()) continue;
            this.stickyPoller.subscribe(worker.getTaskQueue(), worker.workflowWorker);
        }
        if (this.stickyPoller != null) {
            this.stickyPoller.start();
        }
        this.state = State.Started;
    }

    public synchronized boolean isStarted() {
        return this.state != State.Initial;
    }

    public synchronized boolean isShutdown() {
        return this.state == State.Shutdown;
    }

    public synchronized boolean isTerminated() {
        if (this.state != State.Shutdown) {
            return false;
        }
        if (this.stickyPoller != null && !this.stickyPoller.isTerminated()) {
            return false;
        }
        for (Worker worker : this.workers.values()) {
            if (worker.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public WorkflowClient getWorkflowClient() {
        return this.workflowClient;
    }

    public synchronized void shutdown() {
        log.info("shutdown: {}", (Object)this);
        this.shutdownInternal(false);
    }

    public synchronized void shutdownNow() {
        log.info("shutdownNow: {}", (Object)this);
        this.shutdownInternal(true);
    }

    private void shutdownInternal(boolean interruptUserTasks) {
        this.state = State.Shutdown;
        ShutdownManager shutdownManager = new ShutdownManager();
        ((CompletableFuture)((CompletableFuture)this.stickyPoller.shutdown(shutdownManager, interruptUserTasks).thenCompose(ignore -> CompletableFuture.allOf((CompletableFuture[])this.workers.values().stream().map(worker -> worker.shutdown(shutdownManager, interruptUserTasks)).toArray(CompletableFuture[]::new)))).thenApply(r -> {
            this.cache.invalidateAll();
            this.workflowThreadPool.shutdownNow();
            return null;
        })).whenComplete((r, e) -> {
            if (e != null) {
                log.error("[BUG] Unexpected exception during shutdown", e);
            }
            shutdownManager.close();
        });
    }

    public void awaitTermination(long timeout, TimeUnit unit) {
        log.info("awaitTermination begin: {}", (Object)this);
        long timeoutMillis = unit.toMillis(timeout);
        timeoutMillis = ShutdownManager.awaitTermination(this.stickyPoller, timeoutMillis);
        for (Worker worker : this.workers.values()) {
            long t = timeoutMillis;
            timeoutMillis = ShutdownManager.runAndGetRemainingTimeoutMs(t, () -> worker.awaitTermination(t, TimeUnit.MILLISECONDS));
        }
        log.info("awaitTermination done: {}", (Object)this);
    }

    @VisibleForTesting
    WorkflowExecutorCache getCache() {
        return this.cache;
    }

    private String getStickyTaskQueueName() {
        return String.format("%s:%s", this.workflowClient.getOptions().getIdentity(), this.id);
    }

    public synchronized void suspendPolling() {
        if (this.state != State.Started) {
            return;
        }
        log.info("suspendPolling: {}", (Object)this);
        this.state = State.Suspended;
        if (this.stickyPoller != null) {
            this.stickyPoller.suspendPolling();
        }
        for (Worker worker : this.workers.values()) {
            worker.suspendPolling();
        }
    }

    public synchronized void resumePolling() {
        if (this.state != State.Suspended) {
            return;
        }
        log.info("resumePolling: {}", (Object)this);
        this.state = State.Started;
        if (this.stickyPoller != null) {
            this.stickyPoller.resumePolling();
        }
        for (Worker worker : this.workers.values()) {
            worker.resumePolling();
        }
    }

    public String toString() {
        return String.format("WorkerFactory{identity=%s, uniqueId=%s}", this.workflowClient.getOptions().getIdentity(), this.id);
    }

    private static WorkflowThreadExecutor newWorkflowThreadExecutor(ThreadPoolExecutor workflowThreadPool, Scope metricsScope) {
        return r -> workflowThreadPool.submit(() -> {
            metricsScope.gauge("temporal_workflow_active_thread_count").update((double)workflowThreadPool.getActiveCount());
            try {
                r.run();
            }
            finally {
                metricsScope.gauge("temporal_workflow_active_thread_count").update((double)(workflowThreadPool.getActiveCount() - 1));
            }
        });
    }

    static enum State {
        Initial,
        Started,
        Suspended,
        Shutdown;

    }
}

