/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.client.SignalWithStartBatchRequest;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowExecutionAlreadyStarted;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.client.WorkflowStubImpl;
import io.temporal.common.CronSchedule;
import io.temporal.common.MethodRetry;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import io.temporal.workflow.QueryMethod;
import io.temporal.workflow.SignalMethod;
import io.temporal.workflow.WorkflowMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

class WorkflowInvocationHandler
implements InvocationHandler {
    private static final ThreadLocal<SpecificInvocationHandler> invocationContext = new ThreadLocal();
    private final WorkflowStub untyped;
    private final POJOWorkflowInterfaceMetadata workflowMetadata;

    static void initAsyncInvocation(InvocationType type) {
        WorkflowInvocationHandler.initAsyncInvocation(type, null);
    }

    static <T> void initAsyncInvocation(InvocationType type, T value) {
        if (invocationContext.get() != null) {
            throw new IllegalStateException("already in start invocation");
        }
        if (type == InvocationType.START) {
            invocationContext.set(new StartWorkflowInvocationHandler());
        } else if (type == InvocationType.EXECUTE) {
            invocationContext.set(new ExecuteWorkflowInvocationHandler());
        } else if (type == InvocationType.SIGNAL_WITH_START) {
            SignalWithStartBatchRequest batch = (SignalWithStartBatchRequest)value;
            invocationContext.set(new SignalWithStartWorkflowInvocationHandler(batch));
        } else {
            throw new IllegalArgumentException("Unexpected InvocationType: " + (Object)((Object)type));
        }
    }

    static <R> R getAsyncInvocationResult(Class<R> resultClass) {
        SpecificInvocationHandler invocation = invocationContext.get();
        if (invocation == null) {
            throw new IllegalStateException("initAsyncInvocation wasn't called");
        }
        return invocation.getResult(resultClass);
    }

    static void closeAsyncInvocation() {
        invocationContext.remove();
    }

    WorkflowInvocationHandler(Class<?> workflowInterface, WorkflowClientOptions clientOptions, WorkflowClientCallsInterceptor workflowClientCallsInvoker, WorkflowExecution execution) {
        this.workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterface, false);
        Optional<String> workflowType = this.workflowMetadata.getWorkflowType();
        WorkflowStub stub = new WorkflowStubImpl(clientOptions, workflowClientCallsInvoker, workflowType, execution);
        for (WorkflowClientInterceptor i : clientOptions.getInterceptors()) {
            stub = i.newUntypedWorkflowStub(execution, workflowType, stub);
        }
        this.untyped = stub;
    }

    WorkflowInvocationHandler(Class<?> workflowInterface, WorkflowClientOptions clientOptions, WorkflowClientCallsInterceptor workflowClientCallsInvoker, WorkflowOptions options) {
        Objects.requireNonNull(options, "options");
        this.workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterface);
        Optional<POJOWorkflowMethodMetadata> workflowMethodMetadata = this.workflowMetadata.getWorkflowMethod();
        if (!workflowMethodMetadata.isPresent()) {
            throw new IllegalArgumentException("Method annotated with @WorkflowMethod is not found in " + workflowInterface);
        }
        Method workflowMethod = workflowMethodMetadata.get().getWorkflowMethod();
        MethodRetry methodRetry = workflowMethod.getAnnotation(MethodRetry.class);
        CronSchedule cronSchedule = workflowMethod.getAnnotation(CronSchedule.class);
        WorkflowOptions mergedOptions = WorkflowOptions.merge(methodRetry, cronSchedule, options);
        String workflowType = workflowMethodMetadata.get().getName();
        WorkflowStub stub = new WorkflowStubImpl(clientOptions, workflowClientCallsInvoker, workflowType, mergedOptions);
        for (WorkflowClientInterceptor i : clientOptions.getInterceptors()) {
            stub = i.newUntypedWorkflowStub(workflowType, mergedOptions, stub);
        }
        this.untyped = stub;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return "WorkflowInvocationHandler";
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error("unexpected", e);
        }
        if (method.getName().equals("__getUntypedStub")) {
            return this.untyped;
        }
        if (!method.getDeclaringClass().isInterface()) {
            throw new IllegalArgumentException("Interface type is expected: " + method.getDeclaringClass());
        }
        SpecificInvocationHandler handler = invocationContext.get();
        if (handler == null) {
            handler = new SyncWorkflowInvocationHandler();
        }
        handler.invoke(this.workflowMetadata, this.untyped, method, args);
        if (handler.getInvocationType() == InvocationType.SYNC) {
            return handler.getResult(method.getReturnType());
        }
        return Defaults.defaultValue(method.getReturnType());
    }

    private static void startWorkflow(WorkflowStub untyped, Object[] args) {
        block3: {
            Optional<WorkflowOptions> options = untyped.getOptions();
            if (untyped.getExecution() == null || options.isPresent() && options.get().getWorkflowIdReusePolicy() == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE) {
                try {
                    untyped.start(args);
                }
                catch (WorkflowExecutionAlreadyStarted e) {
                    if (!options.isPresent() || options.get().getWorkflowIdReusePolicy() != WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE) break block3;
                    throw e;
                }
            }
        }
    }

    static void checkAnnotations(Method method, WorkflowMethod workflowMethod, QueryMethod queryMethod, SignalMethod signalMethod) {
        int count = (workflowMethod == null ? 0 : 1) + (queryMethod == null ? 0 : 1) + (signalMethod == null ? 0 : 1);
        if (count > 1) {
            throw new IllegalArgumentException(method + " must contain at most one annotation from @WorkflowMethod, @QueryMethod or @SignalMethod");
        }
    }

    private static class SignalWithStartWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private final SignalWithStartBatchRequest batch;

        public SignalWithStartWorkflowInvocationHandler(SignalWithStartBatchRequest batch) {
            this.batch = batch;
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.SIGNAL_WITH_START;
        }

        @Override
        public void invoke(POJOWorkflowInterfaceMetadata workflowMetadata, WorkflowStub untyped, Method method, Object[] args) {
            POJOWorkflowMethodMetadata methodMetadata = workflowMetadata.getMethodMetadata(method);
            switch (methodMetadata.getType()) {
                case QUERY: {
                    throw new IllegalArgumentException("SignalWithStart batch doesn't accept methods annotated with @QueryMethod");
                }
                case WORKFLOW: {
                    this.batch.start(untyped, args);
                    break;
                }
                case SIGNAL: {
                    this.batch.signal(untyped, methodMetadata.getName(), args);
                }
            }
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            throw new IllegalStateException("No result is expected");
        }
    }

    private static class ExecuteWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private Object result;

        private ExecuteWorkflowInvocationHandler() {
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.EXECUTE;
        }

        @Override
        public void invoke(POJOWorkflowInterfaceMetadata workflowMetadata, WorkflowStub untyped, Method method, Object[] args) {
            WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
            if (workflowMethod == null) {
                throw new IllegalArgumentException("WorkflowClient.execute can be called only on a method annotated with @WorkflowMethod");
            }
            WorkflowInvocationHandler.startWorkflow(untyped, args);
            this.result = untyped.getResultAsync(method.getReturnType(), method.getGenericReturnType());
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            return (R)this.result;
        }
    }

    private static class SyncWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private Object result;

        private SyncWorkflowInvocationHandler() {
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.SYNC;
        }

        @Override
        public void invoke(POJOWorkflowInterfaceMetadata workflowMetadata, WorkflowStub untyped, Method method, Object[] args) {
            POJOWorkflowMethodMetadata methodMetadata = workflowMetadata.getMethodMetadata(method);
            WorkflowMethodType type = methodMetadata.getType();
            if (type == WorkflowMethodType.WORKFLOW) {
                this.result = this.startWorkflow(untyped, method, args);
            } else if (type == WorkflowMethodType.QUERY) {
                this.result = this.queryWorkflow(methodMetadata, untyped, method, args);
            } else if (type == WorkflowMethodType.SIGNAL) {
                this.signalWorkflow(methodMetadata, untyped, method, args);
                this.result = null;
            } else {
                throw new IllegalArgumentException(method + " is not annotated with @WorkflowMethod or @QueryMethod");
            }
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            return (R)this.result;
        }

        private void signalWorkflow(POJOWorkflowMethodMetadata methodMetadata, WorkflowStub untyped, Method method, Object[] args) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("Signal method must have void return type: " + method);
            }
            String signalName = methodMetadata.getName();
            untyped.signal(signalName, args);
        }

        private Object queryWorkflow(POJOWorkflowMethodMetadata methodMetadata, WorkflowStub untyped, Method method, Object[] args) {
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Query method cannot have void return type: " + method);
            }
            String queryType = methodMetadata.getName();
            return untyped.query(queryType, method.getReturnType(), method.getGenericReturnType(), args);
        }

        private Object startWorkflow(WorkflowStub untyped, Method method, Object[] args) {
            WorkflowInvocationHandler.startWorkflow(untyped, args);
            return untyped.getResult(method.getReturnType(), method.getGenericReturnType());
        }
    }

    private static class StartWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private Object result;

        private StartWorkflowInvocationHandler() {
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.START;
        }

        @Override
        public void invoke(POJOWorkflowInterfaceMetadata workflowMetadata, WorkflowStub untyped, Method method, Object[] args) {
            WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
            if (workflowMethod == null) {
                throw new IllegalArgumentException("WorkflowClient.start can be called only on a method annotated with @WorkflowMethod");
            }
            this.result = untyped.start(args);
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            return (R)this.result;
        }
    }

    static interface SpecificInvocationHandler {
        public InvocationType getInvocationType();

        public void invoke(POJOWorkflowInterfaceMetadata var1, WorkflowStub var2, Method var3, Object[] var4) throws Throwable;

        public <R> R getResult(Class<R> var1);
    }

    public static enum InvocationType {
        SYNC,
        START,
        EXECUTE,
        SIGNAL_WITH_START;

    }
}

