/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.activity.ActivityCancellationType;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RequestCancelActivityTaskCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.ActivityFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.ActivityTaskCanceledEventAttributes;
import io.temporal.api.history.v1.ActivityTaskCompletedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskFailedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskTimedOutEventAttributes;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;
import java.util.Optional;
import javax.annotation.Nonnull;

final class ActivityStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, ActivityStateMachine> {
    static final String ACTIVITY_FAILED_MESSAGE = "Activity task failed";
    static final String ACTIVITY_TIMED_OUT_MESSAGE = "Activity task timed out";
    static final String ACTIVITY_CANCELED_MESSAGE = "Activity canceled";
    private static final String JAVA_SDK = "JavaSDK";
    private final String activityId;
    private final ActivityType activityType;
    private final ActivityCancellationType cancellationType;
    private final Functions.Proc2<Optional<Payloads>, FailureResult> completionCallback;
    private ExecuteActivityParameters parameters;
    private long startedCommandEventId;
    public static final StateMachineDefinition<State, ExplicitEvent, ActivityStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("Activity", State.CREATED, State.COMPLETED, State.FAILED, State.TIMED_OUT, State.CANCELED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.SCHEDULE_COMMAND_CREATED, ActivityStateMachine::createScheduleActivityTaskCommand).add(State.SCHEDULE_COMMAND_CREATED, CommandType.COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK, State.SCHEDULE_COMMAND_CREATED).add(State.SCHEDULE_COMMAND_CREATED, EventType.EVENT_TYPE_ACTIVITY_TASK_SCHEDULED, State.SCHEDULED_EVENT_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.SCHEDULE_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCELED, ActivityStateMachine::cancelCommandNotifyCanceledImmediately).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_STARTED, State.STARTED, ActivityStateMachine::setStartedCommandEventId).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.SCHEDULED_EVENT_RECORDED, ExplicitEvent.CANCEL, State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, ActivityStateMachine::createRequestCancelActivityTaskCommand).add(State.STARTED, EventType.EVENT_TYPE_ACTIVITY_TASK_COMPLETED, State.COMPLETED, ActivityStateMachine::notifyCompleted).add(State.STARTED, EventType.EVENT_TYPE_ACTIVITY_TASK_FAILED, State.FAILED, ActivityStateMachine::notifyFailed).add(State.STARTED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.STARTED, ExplicitEvent.CANCEL, State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED, ActivityStateMachine::createRequestCancelActivityTaskCommand).add(State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, CommandType.COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK, State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, ActivityStateMachine::notifyCanceledIfTryCancelImmediately).add(State.SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED, State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED).add(State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCELED, State.CANCELED, ActivityStateMachine::notifyCanceledFromEvent).add(State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_STARTED, State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED).add(State.SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED, CommandType.COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK, State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED).add(State.STARTED_ACTIVITY_CANCEL_COMMAND_CREATED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED, State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, ActivityStateMachine::notifyCanceledIfTryCancelFromEvent).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_FAILED, State.FAILED, ActivityStateMachine::notifyFailed).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_COMPLETED, State.COMPLETED, ActivityStateMachine::notifyCompleted).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT, State.TIMED_OUT, ActivityStateMachine::notifyTimedOut).add(State.STARTED_ACTIVITY_CANCEL_EVENT_RECORDED, EventType.EVENT_TYPE_ACTIVITY_TASK_CANCELED, State.CANCELED, ActivityStateMachine::notifyCancellationFromEvent);

    public static ActivityStateMachine newInstance(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, FailureResult> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new ActivityStateMachine(parameters, completionCallback, commandSink, stateMachineSink);
    }

    private ActivityStateMachine(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, FailureResult> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.parameters = parameters;
        ScheduleActivityTaskCommandAttributes.Builder scheduleAttr = parameters.getAttributes();
        this.activityId = scheduleAttr.getActivityId();
        this.activityType = scheduleAttr.getActivityType();
        this.cancellationType = parameters.getCancellationType();
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    public void createScheduleActivityTaskCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK).setScheduleActivityTaskCommandAttributes(this.parameters.getAttributes()).build());
    }

    private void setStartedCommandEventId() {
        this.startedCommandEventId = this.currentEvent.getEventId();
    }

    public void cancel() {
        if (this.cancellationType == ActivityCancellationType.ABANDON) {
            this.notifyCanceled(false);
        } else if (!this.isFinalState()) {
            this.explicitEvent(ExplicitEvent.CANCEL);
        }
    }

    private void cancelCommandNotifyCanceledImmediately() {
        this.cancelCommand();
        if (this.cancellationType != ActivityCancellationType.ABANDON) {
            this.notifyCanceled(false);
        }
    }

    private void notifyCanceledIfTryCancelImmediately() {
        if (this.cancellationType == ActivityCancellationType.TRY_CANCEL) {
            this.notifyCanceled(false);
        }
    }

    private void notifyCanceledIfTryCancelFromEvent() {
        if (this.cancellationType == ActivityCancellationType.TRY_CANCEL) {
            this.notifyCanceled(true);
        }
    }

    private void notifyCanceledFromEvent() {
        this.notifyCanceled(true);
    }

    private void notifyCanceled(boolean fromEvent) {
        Failure canceledFailure = Failure.newBuilder().setSource(JAVA_SDK).setCanceledFailureInfo(CanceledFailureInfo.getDefaultInstance()).build();
        ActivityFailureInfo activityFailureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setIdentity("workflow").setScheduledEventId(this.getInitialCommandEventId()).setStartedEventId(this.startedCommandEventId).build();
        Failure failure = Failure.newBuilder().setActivityFailureInfo(activityFailureInfo).setCause(canceledFailure).setMessage(ACTIVITY_CANCELED_MESSAGE).build();
        this.completionCallback.apply(Optional.empty(), new FailureResult(failure, fromEvent));
    }

    private void notifyCompleted() {
        ActivityTaskCompletedEventAttributes completedAttr = this.currentEvent.getActivityTaskCompletedEventAttributes();
        Optional result = completedAttr.hasResult() ? Optional.of(completedAttr.getResult()) : Optional.empty();
        this.completionCallback.apply(result, null);
    }

    private void notifyFailed() {
        ActivityTaskFailedEventAttributes failed = this.currentEvent.getActivityTaskFailedEventAttributes();
        ActivityFailureInfo failureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setIdentity(failed.getIdentity()).setRetryState(failed.getRetryState()).setScheduledEventId(failed.getScheduledEventId()).setStartedEventId(failed.getStartedEventId()).build();
        Failure failure = Failure.newBuilder().setActivityFailureInfo(failureInfo).setCause(failed.getFailure()).setMessage(ACTIVITY_FAILED_MESSAGE).build();
        this.completionCallback.apply(Optional.empty(), new FailureResult(failure, true));
    }

    private void notifyTimedOut() {
        ActivityTaskTimedOutEventAttributes timedOut = this.currentEvent.getActivityTaskTimedOutEventAttributes();
        ActivityFailureInfo failureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setRetryState(timedOut.getRetryState()).setScheduledEventId(timedOut.getScheduledEventId()).setStartedEventId(timedOut.getStartedEventId()).build();
        Failure failure = Failure.newBuilder().setActivityFailureInfo(failureInfo).setCause(timedOut.getFailure()).setMessage(ACTIVITY_TIMED_OUT_MESSAGE).build();
        this.completionCallback.apply(Optional.empty(), new FailureResult(failure, true));
    }

    private void notifyCancellationFromEvent() {
        if (this.cancellationType == ActivityCancellationType.WAIT_CANCELLATION_COMPLETED) {
            ActivityTaskCanceledEventAttributes canceledAttr = this.currentEvent.getActivityTaskCanceledEventAttributes();
            Failure canceledFailure = Failure.newBuilder().setSource(JAVA_SDK).setCanceledFailureInfo(CanceledFailureInfo.newBuilder().setDetails(canceledAttr.getDetails())).build();
            ActivityFailureInfo failureInfo = ActivityFailureInfo.newBuilder().setActivityId(this.activityId).setActivityType(this.activityType).setScheduledEventId(canceledAttr.getScheduledEventId()).setStartedEventId(canceledAttr.getStartedEventId()).build();
            Failure failure = Failure.newBuilder().setActivityFailureInfo(failureInfo).setCause(canceledFailure).setMessage(ACTIVITY_CANCELED_MESSAGE).build();
            this.completionCallback.apply(Optional.empty(), new FailureResult(failure, true));
        }
    }

    private void createRequestCancelActivityTaskCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK).setRequestCancelActivityTaskCommandAttributes(RequestCancelActivityTaskCommandAttributes.newBuilder().setScheduledEventId(this.getInitialCommandEventId())).build());
        this.parameters = null;
    }

    public static class FailureResult {
        @Nonnull
        private final Failure failure;
        private final boolean fromEvent;

        public FailureResult(@Nonnull Failure failure, boolean fromEvent) {
            this.failure = failure;
            this.fromEvent = fromEvent;
        }

        @Nonnull
        public Failure getFailure() {
            return this.failure;
        }

        public boolean isFromEvent() {
            return this.fromEvent;
        }
    }

    static enum State {
        CREATED,
        SCHEDULE_COMMAND_CREATED,
        SCHEDULED_EVENT_RECORDED,
        STARTED,
        COMPLETED,
        FAILED,
        TIMED_OUT,
        CANCELED,
        SCHEDULED_ACTIVITY_CANCEL_COMMAND_CREATED,
        SCHEDULED_ACTIVITY_CANCEL_EVENT_RECORDED,
        STARTED_ACTIVITY_CANCEL_COMMAND_CREATED,
        STARTED_ACTIVITY_CANCEL_EVENT_RECORDED;

    }

    static enum ExplicitEvent {
        SCHEDULE,
        CANCEL;

    }
}

