/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributesOrBuilder;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;

public interface EagerActivityDispatcher {
    public boolean tryReserveActivitySlot(ScheduleActivityTaskCommandAttributesOrBuilder var1);

    public void releaseActivitySlotReservations(int var1);

    public void dispatchActivity(PollActivityTaskQueueResponse var1);

    public static class NoopEagerActivityDispatcher
    implements EagerActivityDispatcher {
        @Override
        public boolean tryReserveActivitySlot(ScheduleActivityTaskCommandAttributesOrBuilder commandAttributes) {
            return false;
        }

        @Override
        public void releaseActivitySlotReservations(int slotCounts) {
            if (slotCounts > 0) {
                throw new IllegalStateException("Trying to release activity slots on a NoopEagerActivityDispatcher");
            }
        }

        @Override
        public void dispatchActivity(PollActivityTaskQueueResponse activity) {
            throw new IllegalStateException("Trying to dispatch activity on a NoopEagerActivityDispatcher");
        }
    }
}

