/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.common.context.ContextPropagator;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ContinueAsNewOptions {
    private static final ContinueAsNewOptions DEFAULT_INSTANCE = ContinueAsNewOptions.newBuilder().build();
    @Nullable
    private final Duration workflowRunTimeout;
    @Nullable
    private final String taskQueue;
    @Nullable
    private final Duration workflowTaskTimeout;
    @Nullable
    private final Map<String, Object> memo;
    @Nullable
    private final Map<String, Object> searchAttributes;
    @Nullable
    private final List<ContextPropagator> contextPropagators;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ContinueAsNewOptions options) {
        return new Builder(options);
    }

    public static ContinueAsNewOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ContinueAsNewOptions(@Nullable Duration workflowRunTimeout, @Nullable String taskQueue, @Nullable Duration workflowTaskTimeout, @Nullable Map<String, Object> memo, @Nullable Map<String, Object> searchAttributes, @Nullable List<ContextPropagator> contextPropagators) {
        this.workflowRunTimeout = workflowRunTimeout;
        this.taskQueue = taskQueue;
        this.workflowTaskTimeout = workflowTaskTimeout;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.contextPropagators = contextPropagators;
    }

    @Nullable
    public Duration getWorkflowRunTimeout() {
        return this.workflowRunTimeout;
    }

    @Nullable
    public String getTaskQueue() {
        return this.taskQueue;
    }

    @Nullable
    public Duration getWorkflowTaskTimeout() {
        return this.workflowTaskTimeout;
    }

    @Nullable
    public Map<String, Object> getMemo() {
        return this.memo;
    }

    @Nullable
    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    @Nullable
    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public static final class Builder {
        private Duration workflowRunTimeout;
        private String taskQueue;
        private Duration workflowTaskTimeout;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;
        private List<ContextPropagator> contextPropagators;

        private Builder() {
        }

        private Builder(ContinueAsNewOptions options) {
            if (options == null) {
                return;
            }
            this.workflowRunTimeout = options.workflowRunTimeout;
            this.taskQueue = options.taskQueue;
            this.workflowTaskTimeout = options.workflowTaskTimeout;
            this.memo = options.getMemo();
            this.searchAttributes = options.getSearchAttributes();
            this.contextPropagators = options.getContextPropagators();
        }

        public Builder setWorkflowRunTimeout(Duration workflowRunTimeout) {
            this.workflowRunTimeout = workflowRunTimeout;
            return this;
        }

        public Builder setTaskQueue(String taskQueue) {
            this.taskQueue = taskQueue;
            return this;
        }

        public Builder setWorkflowTaskTimeout(Duration workflowTaskTimeout) {
            this.workflowTaskTimeout = workflowTaskTimeout;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public ContinueAsNewOptions build() {
            return new ContinueAsNewOptions(this.workflowRunTimeout, this.taskQueue, this.workflowTaskTimeout, this.memo, this.searchAttributes, this.contextPropagators);
        }
    }
}

