/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachine;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.workflow.Functions;
import javax.annotation.Nullable;

class EntityStateMachineBase<State, ExplicitEvent, Data>
implements EntityStateMachine {
    protected final StateMachine<State, ExplicitEvent, Data> stateMachine;
    protected final Functions.Proc1<CancellableCommand> commandSink;
    protected HistoryEvent currentEvent;
    protected boolean hasNextEvent;

    public EntityStateMachineBase(StateMachineDefinition<State, ExplicitEvent, Data> stateMachineDefinition, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink, @Nullable String entityName) {
        this.stateMachine = StateMachine.newInstance(stateMachineDefinition, entityName);
        this.commandSink = commandSink;
        stateMachineSink.apply(this.stateMachine);
    }

    @Override
    public void handleCommand(CommandType commandType) {
        this.stateMachine.handleCommand(commandType, this);
    }

    @Override
    public WorkflowStateMachines.HandleEventStatus handleEvent(HistoryEvent event, boolean hasNextEvent) {
        if (!this.stateMachine.getValidEventTypes().contains(event.getEventType())) {
            return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
        }
        this.currentEvent = event;
        this.hasNextEvent = hasNextEvent;
        try {
            this.stateMachine.handleHistoryEvent(event.getEventType(), this);
        }
        finally {
            this.currentEvent = null;
        }
        return WorkflowStateMachines.HandleEventStatus.OK;
    }

    @Override
    public void handleWorkflowTaskStarted() {
    }

    protected final void explicitEvent(ExplicitEvent explicitEvent) {
        this.stateMachine.handleExplicitEvent(explicitEvent, this);
    }

    @Override
    public boolean isFinalState() {
        return this.stateMachine.isFinalState();
    }

    protected State getState() {
        return this.stateMachine.getState();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stateMachine=" + this.stateMachine + ", hasNextEvent=" + this.hasNextEvent + ", currentEvent=" + this.currentEvent + '}';
    }
}

