/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.reporter;

import com.uber.m3.tally.Buckets;
import com.uber.m3.tally.Capabilities;
import com.uber.m3.tally.CapableOf;
import com.uber.m3.tally.StatsReporter;
import com.uber.m3.util.Duration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MicrometerClientStatsReporter
implements StatsReporter {
    private final MeterRegistry registry;

    public MicrometerClientStatsReporter(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    public Capabilities capabilities() {
        return CapableOf.REPORTING;
    }

    public void flush() {
    }

    public void close() {
        this.registry.close();
    }

    public void reportCounter(String name, Map<String, String> tags, long value) {
        this.registry.counter(name, this.getTags(tags)).increment((double)value);
    }

    public void reportGauge(String name, Map<String, String> tags, double value) {
        this.registry.gauge(name, this.getTags(tags), (Number)value);
    }

    public void reportTimer(String name, Map<String, String> tags, Duration interval) {
        Timer.builder((String)name).tags(this.getTags(tags)).publishPercentileHistogram(Boolean.valueOf(true)).register(this.registry).record(interval.getNanos(), TimeUnit.NANOSECONDS);
    }

    public void reportHistogramValueSamples(String name, Map<String, String> tags, Buckets buckets, double bucketLowerBound, double bucketUpperBound, long samples) {
    }

    public void reportHistogramDurationSamples(String name, Map<String, String> tags, Buckets buckets, Duration bucketLowerBound, Duration bucketUpperBound, long samples) {
    }

    private Iterable<Tag> getTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
    }
}

