/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.Transition;
import io.temporal.internal.statemachines.TransitionAction;
import io.temporal.internal.statemachines.TransitionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class StateMachine<State, ExplicitEvent, Data> {
    private final StateMachineDefinition<State, ExplicitEvent, Data> definition;
    private State state;
    private final List<Transition<State, TransitionEvent<ExplicitEvent>>> transitionHistory = new ArrayList<Transition<State, TransitionEvent<ExplicitEvent>>>();

    public static <State, ExplicitEvent, Data> StateMachine<State, ExplicitEvent, Data> newInstance(StateMachineDefinition<State, ExplicitEvent, Data> definition) {
        return new StateMachine<State, ExplicitEvent, Data>(definition);
    }

    private StateMachine(StateMachineDefinition<State, ExplicitEvent, Data> definition) {
        this.definition = Objects.requireNonNull(definition);
        this.state = definition.getInitialState();
    }

    public Set<EventType> getValidEventTypes() {
        return this.definition.getValidEventTypes();
    }

    public State getState() {
        return this.state;
    }

    public boolean isFinalState() {
        return this.definition.isFinalState(this.state);
    }

    public void handleExplicitEvent(ExplicitEvent explicitEvent, Data data) {
        this.executeTransition(new TransitionEvent<ExplicitEvent>(explicitEvent), data);
    }

    public void handleHistoryEvent(EventType eventType, Data data) {
        this.executeTransition(new TransitionEvent(eventType), data);
    }

    public void handleCommand(CommandType commandType, Data data) {
        this.executeTransition(new TransitionEvent(commandType), data);
    }

    public String getHistory() {
        return this.transitionHistory.toString();
    }

    List<Transition<State, TransitionEvent<ExplicitEvent>>> getTransitionHistory() {
        return this.transitionHistory;
    }

    public String toString() {
        return "StateMachine{definition=" + this.definition + ", state=" + this.state + ", transitionHistory=" + this.transitionHistory + '}';
    }

    private void executeTransition(TransitionEvent<ExplicitEvent> transitionEvent, Data data) {
        Transition<State, TransitionEvent<ExplicitEvent>> transition = new Transition<State, TransitionEvent<ExplicitEvent>>(this.state, transitionEvent);
        TransitionAction<State, Data> destination = this.definition.getTransitionAction(transition);
        if (destination == null) {
            throw new IllegalArgumentException(this.definition.getName() + ": invalid " + transition + ", transition history is " + this.transitionHistory);
        }
        try {
            this.state = destination.apply(data);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(this.definition.getName() + ": failure executing " + transition + ", transition history is " + this.transitionHistory, e);
        }
        this.transitionHistory.add(transition);
    }
}

