/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.UnsupportedVersion;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class VersionStateMachine {
    static final String MARKER_VERSION_KEY = "version";
    static final String MARKER_CHANGE_ID_KEY = "changeId";
    static final String VERSION_MARKER_NAME = "Version";
    private final DataConverter dataConverter = DataConverter.getDefaultInstance();
    private final String changeId;
    private final Functions.Func<Boolean> replaying;
    private final Functions.Proc1<CancellableCommand> commandSink;
    private final Functions.Proc1<StateMachine> stateMachineSink;
    private Optional<Integer> version = Optional.empty();
    public static final StateMachineDefinition<State, ExplicitEvent, InvocationStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("Version", State.CREATED, State.MARKER_COMMAND_RECORDED, State.SKIPPED_NOTIFIED).add(State.CREATED, ExplicitEvent.CHECK_EXECUTION_STATE, (State[])new State[]{State.REPLAYING, State.EXECUTING}, InvocationStateMachine::getExecutionState).add(State.EXECUTING, ExplicitEvent.SCHEDULE, (State[])new State[]{State.MARKER_COMMAND_CREATED, State.SKIPPED}, InvocationStateMachine::createMarker).add(State.MARKER_COMMAND_CREATED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED, InvocationStateMachine::notifyResult).add(State.RESULT_NOTIFIED, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED).add(State.SKIPPED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.SKIPPED_NOTIFIED, InvocationStateMachine::cancelCommandNotifyCachedResult).add(State.REPLAYING, ExplicitEvent.SCHEDULE, State.MARKER_COMMAND_CREATED_REPLAYING, InvocationStateMachine::createFakeCommand).add(State.MARKER_COMMAND_CREATED_REPLAYING, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED_REPLAYING).add(State.RESULT_NOTIFIED_REPLAYING, ExplicitEvent.NON_MATCHING_EVENT, State.SKIPPED_NOTIFIED, InvocationStateMachine::missingMarkerNotifyCachedOrDefault).add(State.RESULT_NOTIFIED_REPLAYING, (ExplicitEvent)EventType.EVENT_TYPE_MARKER_RECORDED, (State[])new State[]{State.MARKER_COMMAND_RECORDED, State.SKIPPED_NOTIFIED}, InvocationStateMachine::notifyFromEvent);

    private void updateVersionFromEvent(HistoryEvent event) {
        if (this.version.isPresent()) {
            throw new IllegalStateException("Version is already set to " + this.version.get() + ". The most probable cause is retroactive addition of a getVersion call with an existing 'changeId'");
        }
        MarkerRecordedEventAttributes attributes = event.getMarkerRecordedEventAttributes();
        if (!attributes.getMarkerName().equals(VERSION_MARKER_NAME)) {
            throw new IllegalStateException("Expected Version, received: " + attributes);
        }
        Map detailsMap = attributes.getDetailsMap();
        Optional<Payloads> oid = Optional.ofNullable((Payloads)detailsMap.get(MARKER_CHANGE_ID_KEY));
        String idFromMarker = this.dataConverter.fromPayloads(0, oid, String.class, (Type)((Object)String.class));
        if (!this.changeId.equals(idFromMarker)) {
            throw new UnsupportedOperationException("TODO: deal with multiple side effects with different id");
        }
        Optional<Payloads> skipCountPayloads = Optional.ofNullable((Payloads)detailsMap.get(MARKER_VERSION_KEY));
        if (!skipCountPayloads.isPresent()) {
            throw new IllegalStateException("Marker details detailsMap missing required key: version");
        }
        int v = this.dataConverter.fromPayloads(0, skipCountPayloads, Integer.class, (Type)((Object)Integer.class));
        this.version = Optional.of(v);
    }

    public static VersionStateMachine newInstance(String id, Functions.Func<Boolean> replaying, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new VersionStateMachine(id, replaying, commandSink, stateMachineSink);
    }

    private VersionStateMachine(String changeId, Functions.Func<Boolean> replaying, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        this.changeId = Objects.requireNonNull(changeId);
        this.replaying = Objects.requireNonNull(replaying);
        this.commandSink = Objects.requireNonNull(commandSink);
        this.stateMachineSink = stateMachineSink;
    }

    public void getVersion(int minSupported, int maxSupported, Functions.Proc1<Integer> callback) {
        InvocationStateMachine ism = new InvocationStateMachine(minSupported, maxSupported, callback);
        ism.explicitEvent(ExplicitEvent.CHECK_EXECUTION_STATE);
        ism.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    public void handleNonMatchingEvent(HistoryEvent event) {
        this.updateVersionFromEvent(event);
    }

    @VisibleForTesting
    class InvocationStateMachine
    extends EntityStateMachineInitialCommand<State, ExplicitEvent, InvocationStateMachine> {
        private final int minSupported;
        private final int maxSupported;
        private final Functions.Proc1<Integer> resultCallback;

        InvocationStateMachine(int minSupported, int maxSupported, Functions.Proc1<Integer> callback) {
            super(STATE_MACHINE_DEFINITION, VersionStateMachine.this.commandSink, VersionStateMachine.this.stateMachineSink);
            this.minSupported = minSupported;
            this.maxSupported = maxSupported;
            this.resultCallback = Objects.requireNonNull(callback);
        }

        private void validateVersion() {
            if (!VersionStateMachine.this.version.isPresent()) {
                throw new IllegalStateException("Version not set");
            }
            int v = (Integer)VersionStateMachine.this.version.get();
            if ((v < this.minSupported || v > this.maxSupported) && v != -1) {
                throw new UnsupportedVersion(String.format("Version %d of changeId %s is not supported. Supported v is between %d and %d.", v, VersionStateMachine.this.changeId, this.minSupported, this.maxSupported));
            }
        }

        State getExecutionState() {
            return (Boolean)VersionStateMachine.this.replaying.apply() != false ? State.REPLAYING : State.EXECUTING;
        }

        @Override
        public WorkflowStateMachines.HandleEventStatus handleEvent(HistoryEvent event, boolean hasNextEvent) {
            if (event.getEventType() != EventType.EVENT_TYPE_MARKER_RECORDED || !event.getMarkerRecordedEventAttributes().getMarkerName().equals(VersionStateMachine.VERSION_MARKER_NAME)) {
                this.explicitEvent(ExplicitEvent.NON_MATCHING_EVENT);
                return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
            }
            Map detailsMap = event.getMarkerRecordedEventAttributes().getDetailsMap();
            Optional<Payloads> idPayloads = Optional.ofNullable((Payloads)detailsMap.get(VersionStateMachine.MARKER_CHANGE_ID_KEY));
            String expectedId = VersionStateMachine.this.dataConverter.fromPayloads(0, idPayloads, String.class, (Type)((Object)String.class));
            if (Strings.isNullOrEmpty((String)expectedId)) {
                throw new IllegalStateException("Marker details map missing required key: changeId");
            }
            if (!VersionStateMachine.this.changeId.equals(expectedId)) {
                return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
            }
            super.handleEvent(event, hasNextEvent);
            return WorkflowStateMachines.HandleEventStatus.OK;
        }

        @Override
        public void handleWorkflowTaskStarted() {
            if (this.getState() == State.RESULT_NOTIFIED_REPLAYING) {
                this.explicitEvent(ExplicitEvent.NON_MATCHING_EVENT);
            }
        }

        State createMarker() {
            State toState;
            RecordMarkerCommandAttributes markerAttributes;
            if (VersionStateMachine.this.version.isPresent()) {
                this.validateVersion();
                markerAttributes = RecordMarkerCommandAttributes.getDefaultInstance();
                toState = State.SKIPPED;
            } else {
                VersionStateMachine.this.version = Optional.of(this.maxSupported);
                DataConverter dataConverter = DataConverter.getDefaultInstance();
                HashMap<String, Payloads> details = new HashMap<String, Payloads>();
                details.put(VersionStateMachine.MARKER_CHANGE_ID_KEY, dataConverter.toPayloads(VersionStateMachine.this.changeId).get());
                details.put(VersionStateMachine.MARKER_VERSION_KEY, dataConverter.toPayloads(VersionStateMachine.this.version.get()).get());
                markerAttributes = RecordMarkerCommandAttributes.newBuilder().setMarkerName(VersionStateMachine.VERSION_MARKER_NAME).putAllDetails(details).build();
                toState = State.MARKER_COMMAND_CREATED;
            }
            this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_RECORD_MARKER).setRecordMarkerCommandAttributes(markerAttributes).build());
            return toState;
        }

        void createFakeCommand() {
            this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_RECORD_MARKER).setRecordMarkerCommandAttributes(RecordMarkerCommandAttributes.getDefaultInstance()).build());
        }

        State notifyFromEvent() {
            State r = this.notifyFromEventImpl();
            this.notifyResult();
            return r;
        }

        State notifyFromEventImpl() {
            VersionStateMachine.this.updateVersionFromEvent(this.currentEvent);
            this.validateVersion();
            return State.MARKER_COMMAND_RECORDED;
        }

        void notifyResult() {
            this.resultCallback.apply((Integer)VersionStateMachine.this.version.get());
        }

        void cancelCommandNotifyCachedResult() {
            this.cancelCommand();
            this.notifyResult();
        }

        void missingMarkerNotifyCachedOrDefault() {
            this.cancelCommand();
            if (!VersionStateMachine.this.version.isPresent()) {
                VersionStateMachine.this.version = Optional.of(-1);
            }
            this.notifyResult();
        }
    }

    static enum State {
        CREATED,
        REPLAYING,
        EXECUTING,
        MARKER_COMMAND_CREATED,
        SKIPPED,
        CACHED_RESULT_NOTIFIED,
        RESULT_NOTIFIED,
        SKIPPED_NOTIFIED,
        RESULT_NOTIFIED_REPLAYING,
        MARKER_COMMAND_CREATED_REPLAYING,
        MARKER_COMMAND_RECORDED;

    }

    static enum ExplicitEvent {
        CHECK_EXECUTION_STATE,
        SCHEDULE,
        NON_MATCHING_EVENT;

    }
}

