/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.primitives.Ints;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptorBase;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.internal.context.ContextThreadLocal;
import io.temporal.internal.replay.ExecuteActivityParameters;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.StartChildWorkflowExecutionParameters;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.PotentialDeadlockException;
import io.temporal.internal.sync.RunnerLocalInternal;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.internal.sync.WorkflowThreadImpl;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeterministicRunnerImpl
implements DeterministicRunner {
    private static final int ROOT_THREAD_PRIORITY = 0;
    private static final int CALLBACK_THREAD_PRIORITY = 10;
    private static final int WORKFLOW_THREAD_PRIORITY = 20000000;
    static final String WORKFLOW_ROOT_THREAD_NAME = "workflow-method";
    private static final Logger log = LoggerFactory.getLogger(DeterministicRunnerImpl.class);
    private static final ThreadLocal<WorkflowThread> currentThreadThreadLocal = new ThreadLocal();
    private final Set<WorkflowThread> threads = new TreeSet<WorkflowThread>((t1, t2) -> Ints.compare((int)t1.getPriority(), (int)t2.getPriority()));
    private final Map<RunnerLocalInternal<?>, Object> runnerLocalMap = new HashMap();
    private final List<WorkflowThread> threadsToAdd = Collections.synchronizedList(new ArrayList());
    private final List<NamedRunnable> toExecuteInWorkflowThread = new ArrayList<NamedRunnable>();
    private final Lock lock = new ReentrantLock();
    private final Runnable rootRunnable;
    private final ExecutorService threadPool;
    private final SyncWorkflowContext workflowContext;
    private final WorkflowExecutorCache cache;
    private boolean inRunUntilAllBlocked;
    private boolean closeRequested;
    private boolean closed;
    private int addedThreads;
    private WorkflowOutboundCallsInterceptor interceptorHead = new WorkflowOutboundCallsInterceptorBase(null){

        @Override
        public Object newThread(Runnable runnable, boolean detached, String name) {
            return DeterministicRunnerImpl.this.newThread(runnable, detached, name);
        }
    };
    private final Set<Promise> failedPromises = new HashSet<Promise>();
    private boolean exitRequested;
    private Object exitValue;
    private WorkflowThread rootWorkflowThread;
    private final CancellationScopeImpl runnerCancellationScope;

    static WorkflowThread currentThreadInternal() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            throw new Error("Called from non workflow or workflow callback thread");
        }
        return result;
    }

    static Optional<WorkflowThread> currentThreadInternalIfPresent() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    static void setCurrentThreadInternal(WorkflowThread coroutine) {
        if (coroutine != null) {
            currentThreadThreadLocal.set(coroutine);
            WorkflowThreadMarkerAccessor.markAsWorkflowThread();
        } else {
            currentThreadThreadLocal.set(null);
            WorkflowThreadMarkerAccessor.markAsNonWorkflowThread();
        }
    }

    DeterministicRunnerImpl(Runnable root) {
        this(System::currentTimeMillis, root);
    }

    DeterministicRunnerImpl(Supplier<Long> clock, Runnable root) {
        this(DeterministicRunnerImpl.getDefaultThreadPool(), DeterministicRunnerImpl.newDummySyncWorkflowContext(), root, null);
    }

    private static ThreadPoolExecutor getDefaultThreadPool() {
        ThreadPoolExecutor result = new ThreadPoolExecutor(0, 1000, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        result.setThreadFactory(r -> new Thread(r, "deterministic runner thread"));
        return result;
    }

    DeterministicRunnerImpl(ExecutorService threadPool, SyncWorkflowContext workflowContext, Runnable root) {
        this(threadPool, workflowContext, root, null);
    }

    DeterministicRunnerImpl(ExecutorService threadPool, SyncWorkflowContext workflowContext, Runnable root, WorkflowExecutorCache cache) {
        this.threadPool = threadPool;
        this.workflowContext = workflowContext != null ? workflowContext : DeterministicRunnerImpl.newDummySyncWorkflowContext();
        this.workflowContext.setRunner(this);
        this.cache = cache;
        this.runnerCancellationScope = new CancellationScopeImpl(true, null, null);
        this.rootRunnable = root;
    }

    private WorkflowThreadImpl newRootWorkflowThread(Runnable runnable, boolean detached, String name) {
        return new WorkflowThreadImpl(this.threadPool, this, name, 0, detached, this.runnerCancellationScope, runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
    }

    private static SyncWorkflowContext newDummySyncWorkflowContext() {
        return new SyncWorkflowContext(new DummyReplayWorkflowContext(), DataConverter.getDefaultInstance(), null, null, null);
    }

    SyncWorkflowContext getWorkflowContext() {
        return this.workflowContext;
    }

    @Override
    public void runUntilAllBlocked(long deadlockDetectionTimeout) {
        block18: {
            if (this.rootWorkflowThread == null) {
                this.rootWorkflowThread = (WorkflowThread)this.interceptorHead.newThread(this.rootRunnable, false, WORKFLOW_ROOT_THREAD_NAME);
                this.threads.add(this.rootWorkflowThread);
                this.rootWorkflowThread.start();
            }
            if (!this.rootWorkflowThread.isStarted()) {
                throw new IllegalStateException("start not called");
            }
            this.lock.lock();
            try {
                boolean progress;
                this.checkClosed();
                this.inRunUntilAllBlocked = true;
                Throwable unhandledException = null;
                do {
                    this.threadsToAdd.clear();
                    if (!this.toExecuteInWorkflowThread.isEmpty()) {
                        ArrayList<WorkflowThreadImpl> callbackThreads = new ArrayList<WorkflowThreadImpl>(this.toExecuteInWorkflowThread.size());
                        for (NamedRunnable nr : this.toExecuteInWorkflowThread) {
                            WorkflowThreadImpl thread = new WorkflowThreadImpl(this.threadPool, this, nr.name, 10 + this.addedThreads++, false, this.runnerCancellationScope, nr.runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
                            callbackThreads.add(thread);
                        }
                        for (int i = callbackThreads.size() - 1; i >= 0; --i) {
                            this.threads.add((WorkflowThread)callbackThreads.get(i));
                        }
                    }
                    this.toExecuteInWorkflowThread.clear();
                    progress = false;
                    Iterator<WorkflowThread> ci = this.threads.iterator();
                    while (ci.hasNext()) {
                        WorkflowThread c = ci.next();
                        boolean bl = progress = c.runUntilBlocked(deadlockDetectionTimeout) || progress;
                        if (this.exitRequested) {
                            this.close();
                            break block18;
                        }
                        if (!c.isDone()) continue;
                        ci.remove();
                        if (c.getUnhandledException() == null) continue;
                        unhandledException = c.getUnhandledException();
                        break;
                    }
                    if (unhandledException != null) {
                        this.close();
                        throw WorkflowInternal.wrap(unhandledException);
                    }
                    for (WorkflowThread c : this.threadsToAdd) {
                        this.threads.add(c);
                    }
                } while (progress && !this.threads.isEmpty());
            }
            catch (PotentialDeadlockException e) {
                StringBuilder dump = new StringBuilder();
                for (WorkflowThread t : this.threads) {
                    if (t.getWorkflowThreadContext() == e.getWorkflowThreadContext()) continue;
                    if (dump.length() > 0) {
                        dump.append("\n");
                    }
                    dump.append(t.getStackTrace());
                }
                e.setStackDump(dump.toString());
                throw e;
            }
            finally {
                this.inRunUntilAllBlocked = false;
                this.lock.unlock();
                if (this.closeRequested) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.closed || this.threads.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getExitValue() {
        this.lock.lock();
        try {
            if (!this.closed) {
                throw new Error("not done");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.exitValue;
    }

    @Override
    public void cancel(String reason) {
        this.executeInWorkflowThread("cancel workflow callback", () -> this.rootWorkflowThread.cancel(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList threadFutures = new ArrayList();
        this.lock.lock();
        if (this.closed) {
            this.lock.unlock();
            return;
        }
        this.closeRequested = true;
        if (this.inRunUntilAllBlocked) {
            this.lock.unlock();
            return;
        }
        try {
            for (WorkflowThread workflowThread : this.threadsToAdd) {
                this.threads.add(workflowThread);
            }
            this.threadsToAdd.clear();
            for (WorkflowThread workflowThread : this.threads) {
                threadFutures.add(workflowThread.stopNow());
            }
            this.threads.clear();
            HashSet<Promise> failedPromisesLoop = new HashSet<Promise>(this.failedPromises);
            for (Promise f : failedPromisesLoop) {
                if (!f.isCompleted()) {
                    throw new Error("expected failed");
                }
                try {
                    f.get();
                    throw new Error("unreachable");
                }
                catch (RuntimeException e) {
                    log.warn("Promise completed with exception and was never accessed. The ignored exception:", CheckedExceptionWrapper.unwrap((Throwable)e));
                }
            }
        }
        finally {
            this.closed = true;
            this.lock.unlock();
        }
        for (Future future : threadFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error("Unexpected interrupt", e);
            }
            catch (ExecutionException e) {
                throw new Error("Unexpected failure stopping coroutine", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stackTrace() {
        StringBuilder result = new StringBuilder();
        this.lock.lock();
        try {
            if (this.closed) {
                String string = "Workflow is closed.";
                return string;
            }
            for (WorkflowThread coroutine : this.threads) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                coroutine.addStackTrace(result);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result.toString();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new Error("closed");
        }
    }

    @Override
    public WorkflowThread newThread(Runnable runnable, boolean detached, String name) {
        WorkflowThread result;
        if (name == null) {
            name = "workflow[" + this.workflowContext.getContext().getWorkflowId() + "]-" + this.addedThreads;
        }
        if (this.rootWorkflowThread == null) {
            result = this.rootWorkflowThread = this.newRootWorkflowThread(runnable, detached, name);
        } else {
            this.checkWorkflowThreadOnly();
            this.checkClosed();
            result = new WorkflowThreadImpl(this.threadPool, this, name, 20000000 + this.addedThreads++, detached, CancellationScopeImpl.current(), runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        }
        this.threadsToAdd.add(result);
        return result;
    }

    @Override
    public void setInterceptorHead(WorkflowOutboundCallsInterceptor interceptorHead) {
        this.interceptorHead = Objects.requireNonNull(interceptorHead);
    }

    @Override
    public void executeInWorkflowThread(String name, Runnable runnable) {
        this.lock.lock();
        try {
            this.checkClosed();
            this.toExecuteInWorkflowThread.add(new NamedRunnable(name, runnable));
        }
        finally {
            this.lock.unlock();
        }
    }

    Lock getLock() {
        return this.lock;
    }

    void registerFailedPromise(Promise promise) {
        this.failedPromises.add(promise);
    }

    void forgetFailedPromise(Promise promise) {
        this.failedPromises.remove(promise);
    }

    <R> void exit(R value) {
        this.checkClosed();
        this.checkWorkflowThreadOnly();
        this.exitValue = value;
        this.exitRequested = true;
    }

    private void checkWorkflowThreadOnly() {
        if (!this.inRunUntilAllBlocked) {
            throw new Error("called from non workflow thread");
        }
    }

    <T> Optional<T> getRunnerLocal(RunnerLocalInternal<T> key) {
        if (!this.runnerLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.runnerLocalMap.get(key));
    }

    <T> void setRunnerLocal(RunnerLocalInternal<T> key, T value) {
        this.runnerLocalMap.put(key, value);
    }

    private Map<String, Object> getPropagatedContexts() {
        if (currentThreadThreadLocal.get() != null) {
            return ContextThreadLocal.getCurrentContextForPropagation();
        }
        return this.workflowContext.getContext().getPropagatedContexts();
    }

    private List<ContextPropagator> getContextPropagators() {
        if (currentThreadThreadLocal.get() != null) {
            return ContextThreadLocal.getContextPropagators();
        }
        return this.workflowContext.getContext().getContextPropagators();
    }

    private static class WorkflowThreadMarkerAccessor
    extends WorkflowThreadMarker {
        private WorkflowThreadMarkerAccessor() {
        }

        public static void markAsWorkflowThread() {
            isWorkflowThreadThreadLocal.set(true);
        }

        public static void markAsNonWorkflowThread() {
            isWorkflowThreadThreadLocal.set(false);
        }
    }

    private static final class DummyReplayWorkflowContext
    implements ReplayWorkflowContext {
        private final Timer timer = new Timer();

        private DummyReplayWorkflowContext() {
        }

        @Override
        public WorkflowExecution getWorkflowExecution() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public WorkflowExecution getParentWorkflowExecution() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public WorkflowType getWorkflowType() {
            return WorkflowType.newBuilder().setName("dummy-workflow").build();
        }

        @Override
        public boolean isCancelRequested() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes attributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Optional<String> getContinuedExecutionRunId() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public String getTaskQueue() {
            return "dummy-task-queue";
        }

        @Override
        public String getNamespace() {
            return "dummy-namespace";
        }

        @Override
        public String getWorkflowId() {
            return "dummy-workflow-id";
        }

        @Override
        public String getRunId() {
            return "dummy-run-id";
        }

        @Override
        public Duration getWorkflowRunTimeout() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Duration getWorkflowExecutionTimeout() {
            return Duration.ZERO;
        }

        @Override
        public long getRunStartedTimestampMillis() {
            return 0L;
        }

        @Override
        public long getWorkflowExecutionExpirationTimestampMillis() {
            return 0L;
        }

        @Override
        public Duration getWorkflowTaskTimeout() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public SearchAttributes getSearchAttributes() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Map<String, Object> getPropagatedContexts() {
            return null;
        }

        @Override
        public List<ContextPropagator> getContextPropagators() {
            return null;
        }

        @Override
        public Functions.Proc1<Exception> scheduleActivityTask(ExecuteActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Functions.Proc1<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Functions.Proc1<WorkflowExecution> executionCallback, Functions.Proc2<Optional<Payloads>, Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Functions.Proc1<Exception> signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes.Builder attributes, Functions.Proc2<Void, Failure> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void requestCancelExternalWorkflowExecution(WorkflowExecution execution, Functions.Proc2<Void, RuntimeException> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes attributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        @Override
        public Functions.Proc1<RuntimeException> newTimer(Duration delay, final Functions.Proc1<RuntimeException> callback) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    callback.apply(null);
                }
            }, delay.toMillis());
            return e -> callback.apply(new CanceledFailure(null));
        }

        @Override
        public void sideEffect(Functions.Func<Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
            callback.apply(func.apply());
        }

        @Override
        public void mutableSideEffect(String id, Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
            callback.apply(func.apply(Optional.empty()));
        }

        @Override
        public boolean isReplaying() {
            return false;
        }

        @Override
        public void getVersion(String changeId, int minSupported, int maxSupported, Functions.Proc1<Integer> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Random newRandom() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Scope getMetricsScope() {
            return new NoopScope();
        }

        @Override
        public boolean getEnableLoggingInReplay() {
            return false;
        }

        @Override
        public UUID randomUUID() {
            return UUID.randomUUID();
        }

        @Override
        public void upsertSearchAttributes(SearchAttributes searchAttributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public int getAttempt() {
            return 1;
        }
    }

    private static class NamedRunnable {
        private final String name;
        private final Runnable runnable;

        private NamedRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }
    }
}

