/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Throwables;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.PotentialDeadlockException;
import io.temporal.internal.sync.Status;
import io.temporal.workflow.Functions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

class WorkflowThreadContext {
    private final Lock lock;
    private final Condition yieldCondition;
    private final Condition runCondition;
    private final Condition evaluationCondition;
    private Status status = Status.CREATED;
    private Functions.Proc1<String> evaluationFunction;
    private Throwable unhandledException;
    private boolean inRunUntilBlocked;
    private boolean remainedBlocked;
    private String yieldReason;
    private boolean destroyRequested;
    private Thread currentThread;

    WorkflowThreadContext(Lock lock) {
        this.lock = lock;
        this.yieldCondition = lock.newCondition();
        this.runCondition = lock.newCondition();
        this.evaluationCondition = lock.newCondition();
    }

    public void initialYield() {
        Status status = this.getStatus();
        if (status == Status.DONE) {
            throw new DestroyWorkflowThreadError("done in initialYield");
        }
        if (status != Status.RUNNING) {
            throw new IllegalStateException("not in RUNNING but in " + (Object)((Object)status) + " state");
        }
        this.yield("created", () -> true);
    }

    public void yield(String reason, Supplier<Boolean> unblockFunction) {
        if (unblockFunction == null) {
            throw new IllegalArgumentException("null unblockFunction");
        }
        this.lock.lock();
        try {
            while (!this.inRunUntilBlocked || !unblockFunction.get().booleanValue()) {
                if (this.destroyRequested) {
                    throw new DestroyWorkflowThreadError();
                }
                this.status = Status.YIELDED;
                this.runCondition.signal();
                this.yieldCondition.await();
                this.mayBeEvaluate(reason);
                this.yieldReason = reason;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Error("Unexpected interrupt", e);
        }
        finally {
            this.setStatus(Status.RUNNING);
            this.remainedBlocked = false;
            this.yieldReason = null;
            this.lock.unlock();
        }
    }

    private void mayBeEvaluate(String reason) {
        if (this.status == Status.EVALUATING) {
            try {
                this.evaluationFunction.apply(reason);
            }
            catch (Exception e) {
                this.evaluationFunction.apply(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.status = Status.YIELDED;
                this.evaluationCondition.signal();
            }
        }
    }

    public void evaluateInCoroutineContext(Functions.Proc1<String> function) {
        this.lock.lock();
        try {
            if (function == null) {
                throw new IllegalArgumentException("null function");
            }
            if (this.status != Status.YIELDED && this.status != Status.RUNNING) {
                throw new IllegalStateException("Not in yielded status: " + (Object)((Object)this.status));
            }
            if (this.evaluationFunction != null) {
                throw new IllegalStateException("Already evaluating");
            }
            if (this.inRunUntilBlocked) {
                throw new IllegalStateException("Running runUntilBlocked");
            }
            this.evaluationFunction = function;
            this.status = Status.EVALUATING;
            this.yieldCondition.signal();
            while (this.status == Status.EVALUATING) {
                this.evaluationCondition.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Error("Unexpected interrupt", e);
        }
        finally {
            this.evaluationFunction = null;
            this.lock.unlock();
        }
    }

    public Status getStatus() {
        this.lock.lock();
        try {
            Status status = this.status;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setStatus(Status status) {
        this.lock.lock();
        try {
            this.status = status;
            if (this.isDone()) {
                this.runCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.status == Status.DONE;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Throwable getUnhandledException() {
        this.lock.lock();
        try {
            Throwable throwable = this.unhandledException;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUnhandledException(Throwable unhandledException) {
        this.lock.lock();
        try {
            this.unhandledException = unhandledException;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCurrentThread(Thread currentThread) {
        this.currentThread = currentThread;
    }

    public String getYieldReason() {
        return this.yieldReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runUntilBlocked(long deadlockDetectionTimeout) {
        this.lock.lock();
        try {
            if (this.status == Status.DONE) {
                boolean bl = false;
                return bl;
            }
            if (this.evaluationFunction != null) {
                throw new IllegalStateException("Cannot runUntilBlocked while evaluating");
            }
            this.inRunUntilBlocked = true;
            if (this.status != Status.CREATED) {
                this.status = Status.RUNNING;
            }
            this.remainedBlocked = true;
            this.yieldCondition.signal();
            while (this.status == Status.RUNNING || this.status == Status.CREATED) {
                if (!this.runCondition.await(deadlockDetectionTimeout, TimeUnit.MILLISECONDS)) {
                    throw new PotentialDeadlockException(this.currentThread.getName(), this.currentThread.getStackTrace(), this);
                }
                if (this.evaluationFunction == null) continue;
                throw new IllegalStateException("Cannot runUntilBlocked while evaluating");
            }
            boolean bl = !this.remainedBlocked;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!this.isDestroyRequested()) {
                throw new Error("Unexpected interrupt", e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.inRunUntilBlocked = false;
            this.lock.unlock();
        }
    }

    public boolean isDestroyRequested() {
        this.lock.lock();
        try {
            boolean bl = this.destroyRequested;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        this.lock.lock();
        try {
            this.destroyRequested = true;
            if (this.status == Status.CREATED || this.status == Status.RUNNING || this.status == Status.DONE) {
                this.status = Status.DONE;
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.evaluateInCoroutineContext(r -> {
            throw new DestroyWorkflowThreadError();
        });
        this.runUntilBlocked(DeterministicRunner.getDeadlockDetectionTimeout());
    }

    public void exit() {
        this.lock.lock();
        try {
            this.destroyRequested = true;
        }
        finally {
            this.lock.unlock();
        }
        throw new DestroyWorkflowThreadError();
    }
}

