/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import io.temporal.activity.ActivityOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class WorkflowImplementationOptions {
    private static final WorkflowImplementationOptions DEFAULT_INSTANCE = WorkflowImplementationOptions.newBuilder().build();
    private final Class<? extends Throwable>[] failWorkflowExceptionTypes;
    private final Map<String, ActivityOptions> activityOptions;
    private final ActivityOptions defaultActivityOptions;

    public static WorkflowImplementationOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public WorkflowImplementationOptions(Class<? extends Throwable>[] failWorkflowExceptionTypes, Map<String, ActivityOptions> activityOptions, ActivityOptions defaultActivityOptions) {
        this.failWorkflowExceptionTypes = failWorkflowExceptionTypes;
        this.activityOptions = activityOptions;
        this.defaultActivityOptions = defaultActivityOptions;
    }

    public Class<? extends Throwable>[] getFailWorkflowExceptionTypes() {
        return this.failWorkflowExceptionTypes;
    }

    public Map<String, ActivityOptions> getActivityOptions() {
        return this.activityOptions;
    }

    public ActivityOptions getDefaultActivityOptions() {
        return this.defaultActivityOptions;
    }

    public String toString() {
        return "WorkflowImplementationOptions{failWorkflowExceptionTypes=" + Arrays.toString(this.failWorkflowExceptionTypes) + ", activityOptions=" + this.activityOptions + ", defaultActivityOptions=" + this.defaultActivityOptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowImplementationOptions that = (WorkflowImplementationOptions)o;
        return Arrays.equals(this.failWorkflowExceptionTypes, that.failWorkflowExceptionTypes) && Objects.equals(this.activityOptions, that.activityOptions) && Objects.equals(this.defaultActivityOptions, that.defaultActivityOptions);
    }

    public int hashCode() {
        int result = Objects.hash(this.activityOptions, this.defaultActivityOptions);
        result = 31 * result + Arrays.hashCode(this.failWorkflowExceptionTypes);
        return result;
    }

    public static final class Builder {
        private Class<? extends Throwable>[] failWorkflowExceptionTypes;
        private Map<String, ActivityOptions> activityOptions;
        private ActivityOptions defaultActivityOptions;

        private Builder() {
        }

        @SafeVarargs
        public final Builder setFailWorkflowExceptionTypes(Class<? extends Throwable> ... failWorkflowExceptionTypes) {
            this.failWorkflowExceptionTypes = failWorkflowExceptionTypes;
            return this;
        }

        public Builder setActivityOptions(Map<String, ActivityOptions> activityOptions) {
            this.activityOptions = new HashMap<String, ActivityOptions>(Objects.requireNonNull(activityOptions));
            return this;
        }

        public Builder setDefaultActivityOptions(ActivityOptions defaultActivityOptions) {
            this.defaultActivityOptions = Objects.requireNonNull(defaultActivityOptions);
            return this;
        }

        public WorkflowImplementationOptions build() {
            return new WorkflowImplementationOptions(this.failWorkflowExceptionTypes == null ? new Class[]{} : this.failWorkflowExceptionTypes, this.activityOptions == null ? new HashMap() : this.activityOptions, this.defaultActivityOptions);
        }
    }
}

