/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.activity.ActivityTaskHandlerImpl;
import io.temporal.internal.activity.LocalActivityExecutionContextFactoryImpl;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.replay.ReplayWorkflowTaskHandler;
import io.temporal.internal.sync.POJOWorkflowImplementationFactory;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.EagerActivityDispatcher;
import io.temporal.internal.worker.LocalActivityWorker;
import io.temporal.internal.worker.QueryReplayHelper;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.internal.worker.WorkflowRunLockManager;
import io.temporal.internal.worker.WorkflowWorker;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.worker.WorkflowTaskDispatchHandle;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWorkflowWorker
implements SuspendableWorker {
    private static final Logger log = LoggerFactory.getLogger(SyncWorkflowWorker.class);
    private final String identity;
    private final String namespace;
    private final String taskQueue;
    private final WorkflowWorker workflowWorker;
    private final QueryReplayHelper queryReplayHelper;
    private final LocalActivityWorker laWorker;
    private final POJOWorkflowImplementationFactory factory;
    private final DataConverter dataConverter;
    private final ActivityTaskHandlerImpl laTaskHandler;

    public SyncWorkflowWorker(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull SingleWorkerOptions singleWorkerOptions, @Nonnull SingleWorkerOptions localActivityOptions, @Nonnull WorkflowRunLockManager runLocks, @Nonnull WorkflowExecutorCache cache, String stickyTaskQueueName, @Nonnull WorkflowThreadExecutor workflowThreadExecutor, @Nonnull EagerActivityDispatcher eagerActivityDispatcher) {
        this.identity = singleWorkerOptions.getIdentity();
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.dataConverter = singleWorkerOptions.getDataConverter();
        this.factory = new POJOWorkflowImplementationFactory(singleWorkerOptions, Objects.requireNonNull(workflowThreadExecutor), singleWorkerOptions.getWorkerInterceptors(), cache, namespace);
        LocalActivityExecutionContextFactoryImpl laActivityExecutionContextFactory = new LocalActivityExecutionContextFactoryImpl();
        this.laTaskHandler = new ActivityTaskHandlerImpl(namespace, taskQueue, localActivityOptions.getDataConverter(), laActivityExecutionContextFactory, localActivityOptions.getWorkerInterceptors(), localActivityOptions.getContextPropagators());
        this.laWorker = new LocalActivityWorker(namespace, taskQueue, localActivityOptions, this.laTaskHandler);
        TaskQueue stickyTaskQueue = null;
        if (stickyTaskQueueName != null) {
            stickyTaskQueue = InternalUtils.createStickyTaskQueue(stickyTaskQueueName, taskQueue);
        }
        ReplayWorkflowTaskHandler taskHandler = new ReplayWorkflowTaskHandler(namespace, this.factory, cache, singleWorkerOptions, stickyTaskQueue, singleWorkerOptions.getStickyQueueScheduleToStartTimeout(), service, this.laWorker.getLocalActivityScheduler());
        this.workflowWorker = new WorkflowWorker(service, namespace, taskQueue, stickyTaskQueueName, singleWorkerOptions, runLocks, cache, taskHandler, eagerActivityDispatcher);
        ReplayWorkflowTaskHandler nonStickyReplayTaskHandler = new ReplayWorkflowTaskHandler(namespace, this.factory, null, singleWorkerOptions, null, Duration.ZERO, service, this.laWorker.getLocalActivityScheduler());
        this.queryReplayHelper = new QueryReplayHelper(nonStickyReplayTaskHandler);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        this.factory.registerWorkflowImplementationTypes(options, workflowImplementationTypes);
    }

    public <R> void registerWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(options, clazz, factory);
    }

    public void registerLocalActivityImplementations(Object ... activitiesImplementation) {
        this.laTaskHandler.registerActivityImplementations(activitiesImplementation);
    }

    @Override
    public boolean start() {
        boolean started = this.workflowWorker.start();
        if (started) {
            this.laWorker.start();
        }
        return started;
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return ((CompletableFuture)this.workflowWorker.shutdown(shutdownManager, interruptTasks).thenCompose(ignore -> this.laWorker.shutdown(shutdownManager, interruptTasks))).exceptionally(e -> {
            log.error("[BUG] Unexpected exception during shutdown", e);
            return null;
        });
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = ShutdownManager.awaitTermination(this.laWorker, unit.toMillis(timeout));
        ShutdownManager.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.workflowWorker.resumePolling();
    }

    public <R> R queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, Class<R> resultClass, Type resultType, Object[] args) throws Exception {
        Optional<Payloads> serializedArgs = this.dataConverter.toPayloads(args);
        Optional<Payloads> result = this.queryReplayHelper.queryWorkflowExecution(history, queryType, serializedArgs);
        return this.dataConverter.fromPayloads(0, result, resultClass, resultType);
    }

    @Override
    public boolean isSuspended() {
        return this.workflowWorker.isSuspended();
    }

    @Override
    public boolean isShutdown() {
        return this.workflowWorker.isShutdown() || this.laWorker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workflowWorker.isTerminated() && this.laWorker.isTerminated();
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        return null;
    }

    public String toString() {
        return String.format("SyncWorkflowWorker{namespace=%s, taskQueue=%s, identity=%s}", this.namespace, this.taskQueue, this.identity);
    }

    @Nullable
    public WorkflowTaskDispatchHandle reserveWorkflowExecutor() {
        return this.workflowWorker.reserveWorkflowExecutor();
    }
}

