/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ChildWorkflowStub;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.Promise;
import io.temporal.workflow.SignalExternalWorkflowException;
import io.temporal.workflow.Workflow;
import java.lang.reflect.Type;
import java.util.Objects;

class ChildWorkflowStubImpl
implements ChildWorkflowStub {
    private final String workflowType;
    private final ChildWorkflowOptions options;
    private final WorkflowOutboundCallsInterceptor outboundCallsInterceptor;
    private final CompletablePromise<WorkflowExecution> execution;

    ChildWorkflowStubImpl(String workflowType, ChildWorkflowOptions options, WorkflowOutboundCallsInterceptor outboundCallsInterceptor) {
        this.workflowType = Objects.requireNonNull(workflowType);
        this.options = ChildWorkflowOptions.newBuilder(options).validateAndBuildWithDefaults();
        this.outboundCallsInterceptor = Objects.requireNonNull(outboundCallsInterceptor);
        this.execution = Workflow.newPromise();
        this.execution.handle((ex, failure) -> null);
    }

    @Override
    public String getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public Promise<WorkflowExecution> getExecution() {
        CompletablePromise<WorkflowExecution> result = Workflow.newPromise();
        result.completeFrom(this.execution);
        return result;
    }

    @Override
    public ChildWorkflowOptions getOptions() {
        return this.options;
    }

    @Override
    public <R> R execute(Class<R> resultClass, Object ... args) {
        return this.execute(resultClass, resultClass, args);
    }

    @Override
    public <R> R execute(Class<R> resultClass, Type resultType, Object ... args) {
        Promise<R> result = this.executeAsync(resultClass, resultType, args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return (R)Defaults.defaultValue(resultClass);
        }
        try {
            return result.get();
        }
        catch (TemporalFailure e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public <R> Promise<R> executeAsync(Class<R> resultClass, Object ... args) {
        return this.executeAsync(resultClass, resultClass, args);
    }

    @Override
    public <R> Promise<R> executeAsync(Class<R> resultClass, Type resultType, Object ... args) {
        WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> result = this.outboundCallsInterceptor.executeChildWorkflow(new WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R>(this.getWorkflowIdForStart(this.options), this.workflowType, resultClass, resultType, args, this.options, Header.empty()));
        this.execution.completeFrom(result.getWorkflowExecution());
        return result.getResult();
    }

    @Override
    public void signal(String signalName, Object ... args) {
        Promise<Void> signaled = this.outboundCallsInterceptor.signalExternalWorkflow(new WorkflowOutboundCallsInterceptor.SignalExternalInput((WorkflowExecution)this.execution.get(), signalName, args)).getResult();
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(signaled);
            return;
        }
        try {
            signaled.get();
        }
        catch (SignalExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    private String getWorkflowIdForStart(ChildWorkflowOptions options) {
        String workflowId = options.getWorkflowId();
        if (workflowId == null) {
            workflowId = Workflow.randomUUID().toString();
        }
        return workflowId;
    }
}

