/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.workflow.DynamicUpdateHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateDispatcher {
    private static final Logger log = LoggerFactory.getLogger(UpdateDispatcher.class);
    private final DataConverter dataConverterWithWorkflowContext;
    private final Map<String, WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest> updateCallbacks = new HashMap<String, WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest>();
    private DynamicUpdateHandler dynamicUpdateHandler;
    private WorkflowInboundCallsInterceptor inboundCallsInterceptor;

    public UpdateDispatcher(DataConverter dataConverterWithWorkflowContext) {
        this.dataConverterWithWorkflowContext = dataConverterWithWorkflowContext;
    }

    public void setInboundCallsInterceptor(WorkflowInboundCallsInterceptor inboundCallsInterceptor) {
        this.inboundCallsInterceptor = inboundCallsInterceptor;
    }

    public void handleValidateUpdate(String updateName, Optional<Payloads> input, long eventId) {
        Object[] args;
        WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest handler = this.updateCallbacks.get(updateName);
        if (handler == null) {
            if (this.dynamicUpdateHandler == null) {
                throw new IllegalArgumentException("Unknown update name: " + updateName + ", knownTypes=" + this.updateCallbacks.keySet());
            }
            args = new Object[]{new EncodedValues(input, this.dataConverterWithWorkflowContext)};
        } else {
            args = this.dataConverterWithWorkflowContext.fromPayloads(input, handler.getArgTypes(), handler.getGenericArgTypes());
        }
        this.inboundCallsInterceptor.validateUpdate(new WorkflowInboundCallsInterceptor.UpdateInput(updateName, args));
    }

    public Optional<Payloads> handleExecuteUpdate(String updateName, Optional<Payloads> input, long eventId) {
        Object[] args;
        WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest handler = this.updateCallbacks.get(updateName);
        if (handler == null) {
            if (this.dynamicUpdateHandler == null) {
                throw new IllegalArgumentException("Unknown update name: " + updateName + ", knownTypes=" + this.updateCallbacks.keySet());
            }
            args = new Object[]{new EncodedValues(input, this.dataConverterWithWorkflowContext)};
        } else {
            args = this.dataConverterWithWorkflowContext.fromPayloads(input, handler.getArgTypes(), handler.getGenericArgTypes());
        }
        Object result = this.inboundCallsInterceptor.executeUpdate(new WorkflowInboundCallsInterceptor.UpdateInput(updateName, args)).getResult();
        return this.dataConverterWithWorkflowContext.toPayloads(result);
    }

    public void registerUpdateHandlers(WorkflowOutboundCallsInterceptor.RegisterUpdateHandlersInput input) {
        for (WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest request : input.getRequests()) {
            String updateName = request.getUpdateName();
            if (this.updateCallbacks.containsKey(updateName)) {
                throw new IllegalStateException("Update \"" + updateName + "\" is already registered");
            }
            this.updateCallbacks.put(updateName, request);
        }
    }

    public void registerDynamicUpdateHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicUpdateHandlerInput input) {
        this.dynamicUpdateHandler = input.getHandler();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleInterceptedValidateUpdate(WorkflowInboundCallsInterceptor.UpdateInput input) {
        String updateName = input.getUpdateName();
        Object[] args = input.getArguments();
        WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest handler = this.updateCallbacks.get(updateName);
        if (handler == null) {
            if (this.dynamicUpdateHandler == null) throw new IllegalStateException("Unknown update name: " + updateName);
            this.dynamicUpdateHandler.handleValidate(updateName, (EncodedValues)args[0]);
            return;
        } else {
            handler.getValidateCallback().apply(args);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WorkflowInboundCallsInterceptor.UpdateOutput handleInterceptedExecuteUpdate(WorkflowInboundCallsInterceptor.UpdateInput input) {
        Object result;
        String updateName = input.getUpdateName();
        Object[] args = input.getArguments();
        WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest handler = this.updateCallbacks.get(updateName);
        if (handler == null) {
            if (this.dynamicUpdateHandler == null) throw new IllegalStateException("Unknown update name: " + updateName);
            result = this.dynamicUpdateHandler.handleExecute(updateName, (EncodedValues)args[0]);
            return new WorkflowInboundCallsInterceptor.UpdateOutput(result);
        } else {
            result = handler.getExecuteCallback().apply(args);
        }
        return new WorkflowInboundCallsInterceptor.UpdateOutput(result);
    }
}

