/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.reflect.TypeToken;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.TaskReachability;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.GetWorkerBuildIdCompatibilityRequest;
import io.temporal.api.workflowservice.v1.GetWorkerBuildIdCompatibilityResponse;
import io.temporal.api.workflowservice.v1.GetWorkerTaskReachabilityRequest;
import io.temporal.api.workflowservice.v1.GetWorkerTaskReachabilityResponse;
import io.temporal.api.workflowservice.v1.UpdateWorkerBuildIdCompatibilityRequest;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.ActivityCompletionClientImpl;
import io.temporal.client.BatchRequest;
import io.temporal.client.BuildIdOperation;
import io.temporal.client.GetWorkflowExecutionHistoryIterator;
import io.temporal.client.ListWorkflowExecutionIterator;
import io.temporal.client.SignalWithStartBatchRequest;
import io.temporal.client.WorkerBuildIdVersionSets;
import io.temporal.client.WorkerTaskReachability;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowExecutionMetadata;
import io.temporal.client.WorkflowInvocationHandler;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.client.WorkflowStubImpl;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.internal.client.RootWorkflowClientInvoker;
import io.temporal.internal.client.WorkerFactoryRegistry;
import io.temporal.internal.client.WorkflowClientInternal;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.client.external.GenericWorkflowClientImpl;
import io.temporal.internal.client.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.sync.StubMarker;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkerFactory;
import io.temporal.workflow.Functions;
import io.temporal.workflow.QueryMethod;
import io.temporal.workflow.SignalMethod;
import io.temporal.workflow.WorkflowMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class WorkflowClientInternalImpl
implements WorkflowClient,
WorkflowClientInternal {
    private final GenericWorkflowClient genericClient;
    private final WorkflowClientOptions options;
    private final ManualActivityCompletionClientFactory manualActivityCompletionClientFactory;
    private final WorkflowClientCallsInterceptor workflowClientCallsInvoker;
    private final WorkflowServiceStubs workflowServiceStubs;
    private final Scope metricsScope;
    private final WorkflowClientInterceptor[] interceptors;
    private final WorkerFactoryRegistry workerFactoryRegistry = new WorkerFactoryRegistry();

    public static WorkflowClient newInstance(WorkflowServiceStubs service, WorkflowClientOptions options) {
        WorkflowThreadMarker.enforceNonWorkflowThread();
        return (WorkflowClient)WorkflowThreadMarker.protectFromWorkflowThread((Object)new WorkflowClientInternalImpl(service, options), WorkflowClient.class);
    }

    WorkflowClientInternalImpl(WorkflowServiceStubs workflowServiceStubs, WorkflowClientOptions options) {
        this.options = options = WorkflowClientOptions.newBuilder(options).validateAndBuildWithDefaults();
        this.workflowServiceStubs = workflowServiceStubs;
        this.metricsScope = workflowServiceStubs.getOptions().getMetricsScope().tagged(MetricsTag.defaultTags((String)options.getNamespace()));
        this.genericClient = new GenericWorkflowClientImpl(workflowServiceStubs, this.metricsScope);
        this.interceptors = options.getInterceptors();
        this.workflowClientCallsInvoker = this.initializeClientInvoker();
        this.manualActivityCompletionClientFactory = ManualActivityCompletionClientFactory.newFactory(workflowServiceStubs, options.getNamespace(), options.getIdentity(), options.getDataConverter());
    }

    private WorkflowClientCallsInterceptor initializeClientInvoker() {
        WorkflowClientCallsInterceptor workflowClientInvoker = new RootWorkflowClientInvoker(this.genericClient, this.options, this.workerFactoryRegistry);
        for (WorkflowClientInterceptor clientInterceptor : this.interceptors) {
            workflowClientInvoker = clientInterceptor.workflowClientCallsInterceptor(workflowClientInvoker);
        }
        return workflowClientInvoker;
    }

    @Override
    public WorkflowServiceStubs getWorkflowServiceStubs() {
        return this.workflowServiceStubs;
    }

    @Override
    public WorkflowClientOptions getOptions() {
        return this.options;
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, WorkflowOptions options) {
        WorkflowClientInternalImpl.checkAnnotation(workflowInterface, WorkflowMethod.class);
        WorkflowInvocationHandler invocationHandler = new WorkflowInvocationHandler(workflowInterface, this.getOptions(), this.workflowClientCallsInvoker, options);
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class}, (InvocationHandler)invocationHandler);
    }

    @SafeVarargs
    private static <T> void checkAnnotation(Class<T> workflowInterface, Class<? extends Annotation> ... annotationClasses) {
        TypeToken.TypeSet interfaces = TypeToken.of(workflowInterface).getTypes().interfaces();
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException("Workflow must implement at least one interface");
        }
        for (TypeToken i : interfaces) {
            for (Method method : i.getRawType().getMethods()) {
                for (Class<? extends Annotation> annotationClass : annotationClasses) {
                    Annotation workflowMethod = method.getAnnotation(annotationClass);
                    if (workflowMethod == null) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Workflow interface " + workflowInterface.getName() + " doesn't have method annotated with any of " + Arrays.toString(annotationClasses));
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, String workflowId) {
        return this.newWorkflowStub(workflowInterface, workflowId, Optional.empty());
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, String workflowId, Optional<String> runId) {
        WorkflowClientInternalImpl.checkAnnotation(workflowInterface, WorkflowMethod.class, QueryMethod.class, SignalMethod.class);
        if (Strings.isNullOrEmpty((String)workflowId)) {
            throw new IllegalArgumentException("workflowId is null or empty");
        }
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
        WorkflowInvocationHandler invocationHandler = new WorkflowInvocationHandler(workflowInterface, this.getOptions(), this.workflowClientCallsInvoker, execution);
        Object result = Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class}, (InvocationHandler)invocationHandler);
        return (T)result;
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowId) {
        return this.newUntypedWorkflowStub(workflowId, Optional.empty(), Optional.empty());
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowType, WorkflowOptions workflowOptions) {
        WorkflowStub result = new WorkflowStubImpl(this.options, this.workflowClientCallsInvoker, workflowType, workflowOptions);
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newUntypedWorkflowStub(workflowType, workflowOptions, result);
        }
        return result;
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowId, Optional<String> runId, Optional<String> workflowType) {
        WorkflowExecution execution = WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
        return this.newUntypedWorkflowStub(execution, workflowType);
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(WorkflowExecution execution, Optional<String> workflowType) {
        WorkflowStub result = new WorkflowStubImpl(this.options, this.workflowClientCallsInvoker, workflowType, execution);
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newUntypedWorkflowStub(execution, workflowType, result);
        }
        return result;
    }

    @Override
    public ActivityCompletionClient newActivityCompletionClient() {
        ActivityCompletionClient result = (ActivityCompletionClient)WorkflowThreadMarker.protectFromWorkflowThread((Object)new ActivityCompletionClientImpl(this.manualActivityCompletionClientFactory, () -> {}, this.metricsScope, null), ActivityCompletionClient.class);
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newActivityCompletionClient(result);
        }
        return result;
    }

    @Override
    public BatchRequest newSignalWithStartRequest() {
        return new SignalWithStartBatchRequest();
    }

    @Override
    public WorkflowExecution signalWithStart(BatchRequest signalWithStartBatch) {
        return ((SignalWithStartBatchRequest)signalWithStartBatch).invoke();
    }

    @Override
    public Stream<WorkflowExecutionMetadata> listExecutions(@Nullable String query) {
        return this.listExecutions(query, null);
    }

    Stream<WorkflowExecutionMetadata> listExecutions(@Nullable String query, @Nullable Integer pageSize) {
        ListWorkflowExecutionIterator iterator = new ListWorkflowExecutionIterator(query, this.options.getNamespace(), pageSize, this.genericClient);
        iterator.init();
        Iterator wrappedIterator = Iterators.transform((Iterator)iterator, info -> new WorkflowExecutionMetadata((WorkflowExecutionInfo)info, this.options.getDataConverter()));
        int CHARACTERISTICS = 1296;
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(wrappedIterator, 1296), false);
    }

    @Override
    public Stream<HistoryEvent> streamHistory(@Nonnull String workflowId) {
        return this.streamHistory(workflowId, null);
    }

    @Override
    public Stream<HistoryEvent> streamHistory(@Nonnull String workflowId, @Nullable String runId) {
        Preconditions.checkNotNull((Object)workflowId, (Object)"workflowId is required");
        WorkflowExecution.Builder executionBuilder = WorkflowExecution.newBuilder().setWorkflowId(workflowId);
        if (runId != null) {
            executionBuilder.setRunId(runId);
        }
        WorkflowExecution execution = executionBuilder.build();
        return this.streamHistory(execution);
    }

    @Override
    public WorkflowExecutionHistory fetchHistory(@Nonnull String workflowId) {
        return this.fetchHistory(workflowId, null);
    }

    @Override
    public WorkflowExecutionHistory fetchHistory(@Nonnull String workflowId, @Nullable String runId) {
        Preconditions.checkNotNull((Object)workflowId, (Object)"execution is required");
        return new WorkflowExecutionHistory(History.newBuilder().addAllEvents((Iterable)this.streamHistory(workflowId, runId).collect(Collectors.toList())).build(), workflowId);
    }

    @Override
    public void updateWorkerBuildIdCompatability(@Nonnull String taskQueue, @Nonnull BuildIdOperation operation) {
        UpdateWorkerBuildIdCompatibilityRequest.Builder reqBuilder = UpdateWorkerBuildIdCompatibilityRequest.newBuilder().setTaskQueue(taskQueue).setNamespace(this.options.getNamespace());
        operation.augmentBuilder(reqBuilder);
        this.genericClient.updateWorkerBuildIdCompatability(reqBuilder.build());
    }

    @Override
    public WorkerBuildIdVersionSets getWorkerBuildIdCompatability(@Nonnull String taskQueue) {
        GetWorkerBuildIdCompatibilityRequest req = GetWorkerBuildIdCompatibilityRequest.newBuilder().setTaskQueue(taskQueue).setNamespace(this.options.getNamespace()).build();
        GetWorkerBuildIdCompatibilityResponse resp = this.genericClient.getWorkerBuildIdCompatability(req);
        return new WorkerBuildIdVersionSets(resp);
    }

    @Override
    public WorkerTaskReachability getWorkerTaskReachability(@Nonnull Iterable<String> buildIds, @Nonnull Iterable<String> taskQueues, TaskReachability reachability) {
        GetWorkerTaskReachabilityRequest req = GetWorkerTaskReachabilityRequest.newBuilder().setNamespace(this.options.getNamespace()).addAllBuildIds(buildIds).addAllTaskQueues(taskQueues).setReachability(reachability).build();
        GetWorkerTaskReachabilityResponse resp = this.genericClient.GetWorkerTaskReachability(req);
        return new WorkerTaskReachability(resp);
    }

    public static WorkflowExecution start(Functions.Proc workflow) {
        WorkflowThreadMarker.enforceNonWorkflowThread();
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.START);
        try {
            workflow.apply();
            WorkflowExecution workflowExecution = WorkflowInvocationHandler.getAsyncInvocationResult(WorkflowExecution.class);
            return workflowExecution;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    public static <A1> WorkflowExecution start(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1));
    }

    public static <A1, A2> WorkflowExecution start(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3> WorkflowExecution start(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> WorkflowExecution start(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> WorkflowExecution start(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> WorkflowExecution start(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> WorkflowExecution start(Functions.Func<R> workflow) {
        return WorkflowClientInternalImpl.start(workflow::apply);
    }

    public static <A1, R> WorkflowExecution start(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1));
    }

    public static <A1, A2, R> WorkflowExecution start(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> WorkflowExecution start(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> WorkflowExecution start(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> WorkflowExecution start(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> WorkflowExecution start(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static CompletableFuture<Void> execute(Functions.Proc workflow) {
        WorkflowThreadMarker.enforceNonWorkflowThread();
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.EXECUTE);
        try {
            workflow.apply();
            CompletableFuture completableFuture = WorkflowInvocationHandler.getAsyncInvocationResult(CompletableFuture.class);
            return completableFuture;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    public static <A1> CompletableFuture<Void> execute(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1));
    }

    public static <A1, A2> CompletableFuture<Void> execute(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3> CompletableFuture<Void> execute(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> CompletableFuture<Void> execute(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> CompletableFuture<Void> execute(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> CompletableFuture<Void> execute(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> CompletableFuture<R> execute(Functions.Func<R> workflow) {
        return WorkflowClientInternalImpl.execute(workflow::apply);
    }

    public static <A1, R> CompletableFuture<R> execute(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1));
    }

    public static <A1, A2, R> CompletableFuture<R> execute(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> CompletableFuture<R> execute(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> CompletableFuture<R> execute(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> CompletableFuture<R> execute(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> CompletableFuture<R> execute(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    Stream<HistoryEvent> streamHistory(WorkflowExecution execution) {
        Preconditions.checkNotNull((Object)execution, (Object)"execution is required");
        GetWorkflowExecutionHistoryIterator iterator = new GetWorkflowExecutionHistoryIterator(this.options.getNamespace(), execution, null, this.genericClient);
        iterator.init();
        int CHARACTERISTICS = 1297;
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1297), false);
    }

    @Override
    public Object getInternal() {
        return this;
    }

    @Override
    public void registerWorkerFactory(WorkerFactory workerFactory) {
        this.workerFactoryRegistry.register(workerFactory);
    }

    @Override
    public void deregisterWorkerFactory(WorkerFactory workerFactory) {
        this.workerFactoryRegistry.deregister(workerFactory);
    }
}

