/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.client.schedules.ScheduleActionExecution;
import io.temporal.client.schedules.ScheduleActionResult;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ScheduleInfo {
    private final long numActions;
    private final long numActionsMissedCatchupWindow;
    private final long numActionsSkippedOverlap;
    private final List<ScheduleActionExecution> runningActions;
    private final List<ScheduleActionResult> recentActions;
    private final List<Instant> nextActionTimes;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    public ScheduleInfo(long numActions, long numActionsMissedCatchupWindow, long numActionsSkippedOverlap, List<ScheduleActionExecution> runningActions, List<ScheduleActionResult> recentActions, List<Instant> nextActionTimes, Instant createdAt, Instant lastUpdatedAt) {
        this.numActions = numActions;
        this.numActionsMissedCatchupWindow = numActionsMissedCatchupWindow;
        this.numActionsSkippedOverlap = numActionsSkippedOverlap;
        this.runningActions = runningActions;
        this.recentActions = recentActions;
        this.nextActionTimes = nextActionTimes;
        this.createdAt = createdAt;
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public long getNumActions() {
        return this.numActions;
    }

    public long getNumActionsMissedCatchupWindow() {
        return this.numActionsMissedCatchupWindow;
    }

    public long getNumActionsSkippedOverlap() {
        return this.numActionsSkippedOverlap;
    }

    public List<ScheduleActionExecution> getRunningActions() {
        return this.runningActions;
    }

    public List<ScheduleActionResult> getRecentActions() {
        return this.recentActions;
    }

    public List<Instant> getNextActionTimes() {
        return this.nextActionTimes;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Instant getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleInfo that = (ScheduleInfo)o;
        return this.numActions == that.numActions && this.numActionsMissedCatchupWindow == that.numActionsMissedCatchupWindow && this.numActionsSkippedOverlap == that.numActionsSkippedOverlap && Objects.equals(this.runningActions, that.runningActions) && Objects.equals(this.recentActions, that.recentActions) && Objects.equals(this.nextActionTimes, that.nextActionTimes) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.lastUpdatedAt, that.lastUpdatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.numActions, this.numActionsMissedCatchupWindow, this.numActionsSkippedOverlap, this.runningActions, this.recentActions, this.nextActionTimes, this.createdAt, this.lastUpdatedAt);
    }

    public String toString() {
        return "ScheduleInfo{numActions=" + this.numActions + ", numActionsMissedCatchupWindow=" + this.numActionsMissedCatchupWindow + ", numActionsSkippedOverlap=" + this.numActionsSkippedOverlap + ", runningActions=" + this.runningActions + ", recentActions=" + this.recentActions + ", nextActionTimes=" + this.nextActionTimes + ", createdAt=" + this.createdAt + ", lastUpdatedAt=" + this.lastUpdatedAt + '}';
    }
}

