/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProtobufTimeUtils {
    @Nonnull
    public static java.time.Duration toJavaDuration(Duration d) {
        if (d == null) {
            return java.time.Duration.ZERO;
        }
        return java.time.Duration.ofMillis(Durations.toMillis((Duration)d));
    }

    public static Duration toProtoDuration(java.time.Duration d) {
        if (d == null) {
            return Durations.ZERO;
        }
        return Durations.fromMillis((long)d.toMillis());
    }

    public static Timestamp getCurrentProtoTime() {
        return Timestamps.fromMillis((long)System.currentTimeMillis());
    }

    public static com.uber.m3.util.Duration toM3Duration(Timestamp to, Timestamp from) {
        return com.uber.m3.util.Duration.ofMillis((double)(Timestamps.toMillis((Timestamp)to) - Timestamps.toMillis((Timestamp)from)));
    }

    public static com.uber.m3.util.Duration toM3DurationSinceNow(Timestamp t) {
        return com.uber.m3.util.Duration.ofMillis((double)(System.currentTimeMillis() - Timestamps.toMillis((Timestamp)t)));
    }

    @Nullable
    public static Instant toJavaInstant(@Nullable Timestamp t) {
        if (t == null) {
            return null;
        }
        return Instant.ofEpochSecond(t.getSeconds(), t.getNanos());
    }

    @Nullable
    public static Timestamp toProtoTimestamp(@Nullable Instant t) {
        if (t == null) {
            return null;
        }
        return Timestamp.newBuilder().setSeconds(t.getEpochSecond()).setNanos(t.getNano()).build();
    }
}

