/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.Duration;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionCancelRequestedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionSignaledEventAttributes;
import io.temporal.api.protocol.v1.Message;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.update.v1.Input;
import io.temporal.api.update.v1.Request;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.UpdateMessage;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContextImpl;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.internal.worker.WorkflowExecutionException;
import java.util.Optional;
import javax.annotation.Nullable;

final class ReplayWorkflowExecutor {
    private final ReplayWorkflow workflow;
    private final WorkflowStateMachines workflowStateMachines;
    private final ReplayWorkflowContextImpl context;
    private final Scope metricsScope;

    public ReplayWorkflowExecutor(ReplayWorkflow workflow, WorkflowStateMachines workflowStateMachines, ReplayWorkflowContextImpl context) {
        this.workflow = workflow;
        this.workflowStateMachines = workflowStateMachines;
        this.context = context;
        this.metricsScope = context.getMetricsScope();
    }

    public void eventLoop() {
        boolean completed = this.context.isWorkflowMethodCompleted();
        if (completed) {
            return;
        }
        WorkflowExecutionException failure = null;
        try {
            completed = this.workflow.eventLoop();
        }
        catch (WorkflowExecutionException e) {
            failure = e;
            completed = true;
        }
        catch (CanceledFailure e) {
            if (!this.context.isCancelRequested()) {
                failure = new WorkflowExecutionException(this.workflow.getWorkflowContext().mapWorkflowExceptionToFailure(e));
            }
            completed = true;
        }
        if (completed) {
            this.context.setWorkflowMethodCompleted();
            this.completeWorkflow(failure);
        }
    }

    private void completeWorkflow(@Nullable WorkflowExecutionException failure) {
        if (this.context.isCancelRequested()) {
            this.workflowStateMachines.cancelWorkflow();
            this.metricsScope.counter("temporal_workflow_canceled").inc(1L);
        } else if (failure != null) {
            this.workflowStateMachines.failWorkflow(failure.getFailure());
            this.metricsScope.counter("temporal_workflow_failed").inc(1L);
        } else {
            ContinueAsNewWorkflowExecutionCommandAttributes attributes = this.context.getContinueAsNewOnCompletion();
            if (attributes != null) {
                this.workflowStateMachines.continueAsNewWorkflow(attributes);
                this.metricsScope.counter("temporal_workflow_continue_as_new").inc(1L);
            } else {
                Optional<Payloads> workflowOutput = this.workflow.getOutput();
                this.workflowStateMachines.completeWorkflow(workflowOutput);
                this.metricsScope.counter("temporal_workflow_completed").inc(1L);
            }
        }
        Duration d = ProtobufTimeUtils.toM3Duration(Timestamps.fromMillis((long)System.currentTimeMillis()), Timestamps.fromMillis((long)this.context.getRunStartedTimestampMillis()));
        this.metricsScope.timer("temporal_workflow_endtoend_latency").record(d);
    }

    public void handleWorkflowExecutionCancelRequested(HistoryEvent event) {
        WorkflowExecutionCancelRequestedEventAttributes attributes = event.getWorkflowExecutionCancelRequestedEventAttributes();
        this.context.setCancelRequested();
        String cause = attributes.getCause();
        this.workflow.cancel(cause);
    }

    public void handleWorkflowExecutionSignaled(HistoryEvent event) {
        WorkflowExecutionSignaledEventAttributes signalAttributes = event.getWorkflowExecutionSignaledEventAttributes();
        if (this.context.isWorkflowMethodCompleted()) {
            throw new IllegalStateException("Signal received after workflow is closed.");
        }
        Optional<Payloads> input = signalAttributes.hasInput() ? Optional.of(signalAttributes.getInput()) : Optional.empty();
        this.workflow.handleSignal(signalAttributes.getSignalName(), input, event.getEventId(), signalAttributes.getHeader());
    }

    public void handleWorkflowExecutionUpdated(UpdateMessage updateMessage) {
        if (this.context.isWorkflowMethodCompleted()) {
            throw new IllegalStateException("Update received after workflow is closed.");
        }
        try {
            Message protocolMessage = updateMessage.getMessage();
            Request update = (Request)protocolMessage.getBody().unpack(Request.class);
            Input input = update.getInput();
            Optional<Payloads> args = Optional.ofNullable(input.getArgs());
            this.workflow.handleUpdate(input.getName(), args, protocolMessage.getEventId(), input.getHeader(), updateMessage.getCallbacks());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Message is not an update.");
        }
    }

    public Optional<Payloads> query(WorkflowQuery query) {
        return this.workflow.query(query);
    }

    public void close() {
        this.workflow.close();
    }

    public void start(HistoryEvent startWorkflowEvent) {
        this.workflow.start(startWorkflowEvent, this.context);
    }
}

