/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WorkflowImplementationOptions {
    private static final WorkflowImplementationOptions DEFAULT_INSTANCE = WorkflowImplementationOptions.newBuilder().build();
    private final Class<? extends Throwable>[] failWorkflowExceptionTypes;
    @Nullable
    private final Map<String, ActivityOptions> activityOptions;
    private final ActivityOptions defaultActivityOptions;
    @Nullable
    private final Map<String, LocalActivityOptions> localActivityOptions;
    private final LocalActivityOptions defaultLocalActivityOptions;

    public static WorkflowImplementationOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public WorkflowImplementationOptions(Class<? extends Throwable>[] failWorkflowExceptionTypes, @Nullable Map<String, ActivityOptions> activityOptions, ActivityOptions defaultActivityOptions, @Nullable Map<String, LocalActivityOptions> localActivityOptions, LocalActivityOptions defaultLocalActivityOptions) {
        this.failWorkflowExceptionTypes = failWorkflowExceptionTypes;
        this.activityOptions = activityOptions;
        this.defaultActivityOptions = defaultActivityOptions;
        this.localActivityOptions = localActivityOptions;
        this.defaultLocalActivityOptions = defaultLocalActivityOptions;
    }

    public Class<? extends Throwable>[] getFailWorkflowExceptionTypes() {
        return this.failWorkflowExceptionTypes;
    }

    @Nonnull
    public Map<String, ActivityOptions> getActivityOptions() {
        return this.activityOptions != null ? Collections.unmodifiableMap(this.activityOptions) : Collections.emptyMap();
    }

    public ActivityOptions getDefaultActivityOptions() {
        return this.defaultActivityOptions;
    }

    @Nonnull
    public Map<String, LocalActivityOptions> getLocalActivityOptions() {
        return this.localActivityOptions != null ? Collections.unmodifiableMap(this.localActivityOptions) : Collections.emptyMap();
    }

    public LocalActivityOptions getDefaultLocalActivityOptions() {
        return this.defaultLocalActivityOptions;
    }

    public String toString() {
        return "WorkflowImplementationOptions{failWorkflowExceptionTypes=" + Arrays.toString(this.failWorkflowExceptionTypes) + ", activityOptions=" + this.activityOptions + ", defaultActivityOptions=" + this.defaultActivityOptions + ", localActivityOptions=" + this.localActivityOptions + ", defaultLocalActivityOptions=" + this.defaultLocalActivityOptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowImplementationOptions that = (WorkflowImplementationOptions)o;
        return Arrays.equals(this.failWorkflowExceptionTypes, that.failWorkflowExceptionTypes) && Objects.equals(this.activityOptions, that.activityOptions) && Objects.equals(this.defaultActivityOptions, that.defaultActivityOptions) && Objects.equals(this.localActivityOptions, that.localActivityOptions) && Objects.equals(this.defaultLocalActivityOptions, that.defaultLocalActivityOptions);
    }

    public int hashCode() {
        int result = Objects.hash(this.activityOptions, this.defaultActivityOptions, this.localActivityOptions, this.defaultLocalActivityOptions);
        result = 31 * result + Arrays.hashCode(this.failWorkflowExceptionTypes);
        return result;
    }

    public static final class Builder {
        private Class<? extends Throwable>[] failWorkflowExceptionTypes;
        private Map<String, ActivityOptions> activityOptions;
        private ActivityOptions defaultActivityOptions;
        private Map<String, LocalActivityOptions> localActivityOptions;
        private LocalActivityOptions defaultLocalActivityOptions;

        private Builder() {
        }

        @SafeVarargs
        public final Builder setFailWorkflowExceptionTypes(Class<? extends Throwable> ... failWorkflowExceptionTypes) {
            this.failWorkflowExceptionTypes = failWorkflowExceptionTypes;
            return this;
        }

        public Builder setActivityOptions(Map<String, ActivityOptions> activityOptions) {
            this.activityOptions = new HashMap<String, ActivityOptions>(Objects.requireNonNull(activityOptions));
            return this;
        }

        public Builder setDefaultActivityOptions(ActivityOptions defaultActivityOptions) {
            this.defaultActivityOptions = Objects.requireNonNull(defaultActivityOptions);
            return this;
        }

        public Builder setLocalActivityOptions(Map<String, LocalActivityOptions> localActivityOptions) {
            this.localActivityOptions = new HashMap<String, LocalActivityOptions>(Objects.requireNonNull(localActivityOptions));
            return this;
        }

        public Builder setDefaultLocalActivityOptions(LocalActivityOptions defaultLocalActivityOptions) {
            this.defaultLocalActivityOptions = Objects.requireNonNull(defaultLocalActivityOptions);
            return this;
        }

        public WorkflowImplementationOptions build() {
            return new WorkflowImplementationOptions(this.failWorkflowExceptionTypes == null ? new Class[]{} : this.failWorkflowExceptionTypes, this.activityOptions == null ? null : this.activityOptions, this.defaultActivityOptions, this.localActivityOptions == null ? null : this.localActivityOptions, this.defaultLocalActivityOptions);
        }
    }
}

