/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.activity.ActivityInfo;
import io.temporal.failure.TemporalException;
import java.util.Optional;

public class ActivityCompletionException
extends TemporalException {
    private final String workflowId;
    private final String runId;
    private final String activityType;
    private final String activityId;

    protected ActivityCompletionException(ActivityInfo info) {
        this(info, null);
    }

    protected ActivityCompletionException(ActivityInfo info, Throwable cause) {
        super(info != null ? "WorkflowId=" + info.getWorkflowId() + ", RunId=" + info.getRunId() + ", ActivityType=" + info.getActivityType() + ", ActivityId=" + info.getActivityId() : null, cause);
        if (info != null) {
            this.workflowId = info.getWorkflowId();
            this.runId = info.getRunId();
            this.activityType = info.getActivityType();
            this.activityId = info.getActivityId();
        } else {
            this.workflowId = null;
            this.runId = null;
            this.activityType = null;
            this.activityId = null;
        }
    }

    protected ActivityCompletionException(String activityId, Throwable cause) {
        super("ActivityId=" + activityId, cause);
        this.workflowId = null;
        this.runId = null;
        this.activityType = null;
        this.activityId = activityId;
    }

    protected ActivityCompletionException(Throwable cause) {
        this((ActivityInfo)null, cause);
    }

    protected ActivityCompletionException() {
        super(null, null);
        this.workflowId = null;
        this.runId = null;
        this.activityType = null;
        this.activityId = null;
    }

    public Optional<String> getWorkflowId() {
        return Optional.ofNullable(this.workflowId);
    }

    public Optional<String> getRunId() {
        return Optional.ofNullable(this.runId);
    }

    public Optional<String> getActivityType() {
        return Optional.ofNullable(this.activityType);
    }

    public Optional<String> getActivityId() {
        return Optional.ofNullable(this.activityId);
    }
}

